/** 
 * @file    kVsXmlConfigParser.x.h
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_VISION_XML_CONFIG_PARSER
#define K_VISION_XML_CONFIG_PARSER

#include <stdio.h>
#include <kApi/Data/kXml.h>
#include <kApi/Data/kMap.h>
#include <kApi/Data/kArrayList.h>
#include <kApi/Io/kDirectory.h>
#include <kApi/Io/kFile.h>
#include <kVision/Vs/kVsModelDefStore.h>
#include <kVision/Vs/kVsXmlUtils.h>

/**
* Reserved kVsXmlConfigTree macros.
*
* @relates        kVsXmlConfigParser
* @{ */

#define kVs_XML_CONFIG_PARSER_DEBUG_INPUT_PATH    "INPUT_PATH"    // provides directory of Config XML
#define kVs_XML_CONFIG_PARSER_DEBUG_FILE_NAME "xmlconfigparser_debug.xml"
#define kVs_XML_CONFIG_PARSER_MACRO_ITERATION_LIMIT  (50)

/** @} */


typedef struct kVsXmlConfigParserClass 
{
    kObjectClass base;
    kString inputDir;
    kString inputFileName;      
    kXml configXml;
} kVsXmlConfigParserClass;

kDeclareClassEx(kVs, kVsXmlConfigParser, kObject)

kVsFx(kStatus) kVsXmlConfigParser_VInitClone(kVsXmlConfigParser optionList, kVsXmlConfigParser source, kAlloc allocator);
kVsFx(kStatus) kVsXmlConfigParser_VRelease(kVsXmlConfigParser optionList);

kStatus kVsXmlConfigParser_Init(kVsXmlConfigParser optionList, const kChar* path, kAlloc allocator);

kStatus kVsXmlConfigParser_Parse(kVsXmlConfigParser parser, kXml output, kMap filter);

#endif  /* #ifndef K_VISION_XML_CONFIG_PARSER */
