#ifndef LMITECH_KVISION_VS_UTILITIES_X_H_INCLUDED
#define LMITECH_KVISION_VS_UTILITIES_X_H_INCLUDED

#include <kApi/Data/kImage.h>
#include <kApi/Data/kArray2.h>
#include <kApi/Io/kFile.h>
#include <kVision/Vs/kVsDef.h>

#define RS_SCALE (1.0 / (1.0 + RAND_MAX))
#define k_VS_UTILITIES_PDF_EDITOR_KEY_SEPARATOR ":"

//////////////////////////////////////////////////////////////////////////
// log to a file
//////////////////////////////////////////////////////////////////////////

#if defined(kVS_LOG_FILE_ENABLED) && defined(K_WINDOWS)

#include <stdio.h>
#include <kApi/IO/kFile.h>

kInlineFx(kStatus) kCall kVsLogFile(const kChar* format, kVarArgList args)
{
    kFile file = kNULL;
    static kChar buffer[500];

    k32s size = vsprintf_s(buffer, 500, format, args);
    if (size < 0) return kERROR;

    kTry;
    {
        kTest(kFile_Construct(&file, "D:\\log.txt", kFILE_MODE_WRITE | kFILE_MODE_UPDATE, kNULL));
        kTest(kStream_Seek(file, 0, kSEEK_ORIGIN_END));
        kTest(kStream_Write(file, buffer, size));
        kTest(kFile_Close(file));
    }
    kFinally;
    {
        kCheck(kDestroyRef(&file));
        kEndFinally();
    }

    return kOK;
}

kInlineFx(kStatus) kVsLog_FileStart()
{
    return kApiLib_SetLogfHandler(kVsLogFile);
}

#else

kInlineFx(kStatus) kVsLog_FileStart()
{
    return kOK;
}

#endif

//////////////////////////////////////////////////////////////////////////
// PROFILER simple
// will leak mem if you bail between START and END, use try finally
//////////////////////////////////////////////////////////////////////////

#ifdef kVS_PROFILE_ENABLED

#include <kApi/Threads/kTimer.h> // kTimer
#include <kVision/Vs/kVsDef.h>   // kVS_FROM_MICRO

#define kxVsProfile_Start_( name ) \
    { \
        kTimer profiler##name##Timer; \
        kTimer_Construct(&profiler##name##Timer, kNULL); \
        kTimer_Start(profiler##name##Timer, 0); \
        { // allows variable declarations after profiler


#define kxVsProfile_End_( name ) \
        } \
        kLogf("%-60s: %2.3f sec\r\n", #name, kVS_FROM_MICRO(kTimer_Elapsed(profiler##name##Timer))); \
        kDestroyRef(&profiler##name##Timer); \
    }

#else

#define kxVsProfile_Start_(name) ((void)0)
#define kxVsProfile_End_(name) ((void)0)

#endif

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#endif /* #ifndef LMITECH_KVISION_VS_UTILITIES_X_H_INCLUDED */
