/**
* @file kVsTrackingWindow.x.h
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
*/

#ifndef K_VISION_TRACKING_WINDOW_X_H
#define K_VISION_TRACKING_WINDOW_X_H

#include <kVision/Vs/kVsTrackingWindow.h>

typedef struct kVsTrackingWindowClass
{
    kObjectClass base;

    kSize x;
    kSSize yMax;
    kSSize yMin;
    kSize yGranularity;
    kSize minSpotCount;
    kSize height;
    kSize xSubSampling;
    kSize ySubSampling;

} kVsTrackingWindowClass;

kDeclareClassEx(kVs, kVsTrackingWindow , kObject)

kVsFx(kStatus) kVsTrackingWindow_VRelease(kVsTrackingWindow trackingWindow);
kVsFx(kStatus) kVsTrackingWindow_VInitClone(kVsTrackingWindow trackingWindow, kVsTrackingWindow source, kAlloc allocator);
kStatus kVsTrackingWindow_Init(kVsTrackingWindow trackingWindow, kAlloc allocator);

#endif /* #ifndef K_VISION_TRACKING_WINDOW_X_H */