/** 
 * @file    kVsPrepareOptions.x.h
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_VISION_PREPARE_OPTIONS_DEF_X_H
#define K_VISION_PREPARE_OPTIONS_DEF_X_H

#include <kApi/Io/kPath.h>
#include <kFireSync/Utils/kSensorIdentity.h>
#include <kVision/Vs/kVsUtilities.h>
#include <kVision/Vs/kVsXmlUtils.h>
#include <stdio.h>

#define kVS_PREPARE_OPTIONS_IDENTIFIER                                  "PrepareOptions"

#define kVS_PREPARE_OPTIONS_SYNTAX_UPGRADE_PACKAGE                      "UpgradePackage"
#define kVS_PREPARE_OPTIONS_SYNTAX_UPGRADE_PACKAGE_PATH                 "Path"
#define kVS_PREPARE_OPTIONS_SYNTAX_UPGRADE_PACKAGE_PREFIX               "Prefix"
#define kVS_PREPARE_OPTIONS_SYNTAX_UPGRADE_PACKAGE_VERSION              "Version"

#define kVS_PREPARE_OPTIONS_SYNTAX_CUSTOM_TOOL_LIST                     "CustomToolList"
#define kVS_PREPARE_OPTIONS_SYNTAX_CUSTOM_TOOL_LIST_PATH                "Path"
#define kVS_PREPARE_OPTIONS_SYNTAX_CUSTOM_TOOL_LIST_PREFIX              "Prefix"
#define kVS_PREPARE_OPTIONS_SYNTAX_CUSTOM_TOOL_LIST_VERSION             "Version"

#define kVS_PREPARE_OPTIONS_SYNTAX_OPTION_NAME                          "OptionName"
#define kVS_PREPARE_OPTIONS_SYNTAX_FIRMWARE                             "Firmware"
#define kVS_PREPARE_OPTIONS_SYNTAX_RESCUE_FIRMWARE                      "RescueFirmware"
#define kVS_PREPARE_OPTIONS_SYNTAX_OS                                   "OS"
#define kVS_PREPARE_OPTIONS_SYNTAX_RESCUE_OS                            "RescueOS"
#define kVS_PREPARE_OPTIONS_SYNTAX_COMPATIBLE_FIRMWARE_TAG              "CompatibleFirmwareTag"
#define kVS_PREPARE_OPTIONS_SYNTAX_LICENSE_FEATURE_IDS                  "LicenseFeatureIds"

#define kVS_PREPARE_OPTIONS_SYNTAX_LABEL                                "label"
#define kVS_PREPARE_OPTIONS_SYNTAX_FILE_LABEL                           "file"
#define kVS_PREPARE_OPTIONS_SYNTAX_FILE_PATH                            "Path"
#define kVS_PREPARE_OPTIONS_SYNTAX_FILE_TARGET                          "Target"
#define kVS_PREPARE_OPTIONS_SYNTAX_CONFIG_LABEL                         "config"
#define kVS_PREPARE_OPTIONS_SYNTAX_CONFIG_VALUE                         "Value"

typedef struct kVsPrepareOptionsClass 
{
    kObjectClass base;

    kMap filterMap;

    kString firmwarePath;           // current Factory firmware path    
    kString rescueFirmwarePath;     // current rescue firmware path
    kString osPath;                 // current TX2 OS firmware path
    kString rescueOsPath;           // current TX2 rescue OS firmware path
    kString upgradePackagePath;     // current upgrade package path     
    kString optionName;             // current option name
    kString upgradeRootPath;        // Path to upgrade packages
    kString upgradePrefix;          // upgrade package prefix
    kString upgradeVersionMask;     // upgrade package version filter
    kString upgradeTargetVersion;   //found version according to filter
    kArrayList licenseFeatures;     // license features
    kString compatibleFirmwareTag;

    kArrayList files[2];            // current source paths and target filenames for storage files[kString target, kString path]
    kArrayList configs[2];          // current source paths and target filenames for XML configs[kString target, kString path]

    kString customToolList;

    //kString customToolListPath;
    //kString customToolListVersion;
    //k32u customToolListPrefix;

} kVsPrepareOptionsClass;

kDeclareClassEx(kVs, kVsPrepareOptions, kObject)

kVsFx(kStatus) kVsPrepareOptions_VRelease(kVsPrepareOptions options);

kStatus kVsPrepareOptions_Init(kVsPrepareOptions options, kXml xml, kMap filterMap, kAlloc allocator);
kStatus kVsPrepareOptions_ParseXml(kVsPrepareOptions options, kXml xml);
kStatus kVsPrepareOptions_ParseCustomToolList(kVsPrepareOptions options, kXml xml);


kStatus kVsPrepareOptions_SourceUpgradePackages(kVsPrepareOptions options, kXml xml);

#endif  /* #ifndef K_VISION_PREPARE_OPTIONS_DEF_X_H */
