/**
* @file    kVsLicense.x.h
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef K_VISION_LICENSE_X_H_INCLUDED
#define K_VISION_LICENSE_X_H_INCLUDED

#include <kApi/Data/kArray1.h>
#include <kApi/Io/kMemory.h>
#include <kVision/Vs/kVsBlowfish.h>

#define kVS_LICENSE_ENCRYPTION_KEY              "!@tr&x#hERDT-6#HEt3aj3t!et9*3ge?919&PH#PRe9hUs3a9E&98hA("
#define kVS_LICENSE_FILE_SIGNATURE              (0x10AAAAABCDEF10AAL)
#define kVS_LICENSE_FILE_VERSION                (1)
#define kVS_LICENSE_BLOCK_SIZE                  (8)

#define kVS_LICENSE_XML_FIELD_HEADER            "License"
#define kVS_LICENSE_XML_FIELD_SERIAL_NUMBER     "SerialNumber"
#define kVS_LICENSE_XML_FIELD_OPTION_CODE       "Package"
#define kVS_LICENSE_XML_ATTR_VERSION            "version"
#define kVS_LICENSE_XML_FIELD_FEATURES          "Features"
#define kVS_LICENSE_XML_FIELD_FEATURE           "Feature"
#define kVS_LICENSE_XML_FIELD_ID                "Id"
#define kVS_LICENSE_XML_FIELD_LOCKED            "Locked"
#define kVs_LICENSE_XML_SCHEMA_VERSION          (2)

typedef struct kVsLicenseHeader 
{
    k64u signature;             // file signature
    k64u version;               // encryption schema version
    k64u length;                // data length

} kVsLicenseHeader;

typedef struct kVsLicenseClass 
{
    kObjectClass base;

    kVsBlowfish blowfish;       // kVsLicenseClass is currently specific to the Blowfish cypher

    k32u serialNumber;          // node id of target sensor
    k32u optionCode;            // OptionCode of target software package
    kArrayList features;        // list of features

} kVsLicenseClass;

kDeclareClassEx(kVs, kVsLicense, kObject)

kVsFx(kStatus) kVsLicense_VInitClone(kVsLicense license, kVsLicense source, kAlloc allocator);
kVsFx(kStatus) kVsLicense_VRelease(kVsLicense license);

kStatus kVsLicense_Init(kVsLicense license, kAlloc allocator);

kStatus kVsLicense_Encrypt(kVsLicense license, const void* data, k32u length, kArray1* result);
kStatus kVsLicense_Decrypt(kVsLicense license, const void* data, k32u length, kArray1* result);

kStatus kVsLicense_ComposeXml(kVsLicense license, kXml* xml);
kStatus kVsLicense_ParseXml(kVsLicense license, kXml xml);

#endif  /* #ifndef K_VISION_LICENSE_X_H_INCLUDED */
