/**
* @file kVsImageStatsAlg.x.h
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
*/

#ifndef K_VISION_IMAGE_STATS_ALG_X_H
#define K_VISION_IMAGE_STATS_ALG_X_H

#include <kVision/Vs/kVsImageStatsAlg.h>

typedef struct kVsImageStatsAlgClass
{
    kObjectClass base;

    kSize averageWindow;
    kSize edgeWindow;
    kSize threshold;
    kSize widthThreshold;
    kSize minWidth;
    kSize maxWidth;
    kSize minSum;
    kBool isSobel;
    kBool rowBased;

    kArrayList spots;

} kVsImageStatsAlgClass;

kDeclareClassEx(kVs, kVsImageStatsAlg , kObject)

kVsFx(kStatus) kVsImageStatsAlg_VRelease(kVsImageStatsAlg imageStats);
kVsFx(kStatus) kVsImageStatsAlg_VInitClone(kVsImageStatsAlg imageStatsAlg, kVsImageStatsAlg source, kAlloc allocator);
kStatus kVsImageStatsAlg_Init(kVsImageStatsAlg imageStatsAlg, kSize spotsCapacity, kAlloc allocator);

#endif /* #ifndef K_VISION_IMAGE_STATS_ALG_X_H */