#ifndef LMITECH_KVISION_L3D_ZIMAGE_NOISEBLOCK_H_INCLUDED
#define LMITECH_KVISION_L3D_ZIMAGE_NOISEBLOCK_H_INCLUDED

#include <kVision/Vs/kVsImageNoiseBlockInfo.h>
#include <kVision/Vs/kVsImageNoiseBlock.h>
#include <kVision/Vs/kVsImageNoiseAlg.h>
#include <kVision/Vs/kVsPrnuMap.h>
#include <kFireSync/Data/kMsg.h>
#include <kFireSync/Pipe/kPxPort.h>

#define kVS_IMAGE_NOISE_BLOCK_DESCRIPTION               "Performs spatial and temporal image characterization"
#define kVS_IMAGE_NOISE_BLOCK_DEFAULT_SAMPLE_COUNT (20)

typedef struct kVsImageNoiseBlockClass
{
    kPxBlockClass base;

    kVsImageNoiseBlockInfo settings;
    kVsImageNoiseAlg alg;

    kArrayList inImages;
    kArrayList inMessages;

    k64f spatialStdev;
    k64f temporalStdev;
    k64f averageIntensity;
    k64f averageTemperature;

    kString statString;

} kVsImageNoiseBlockClass;

kDeclareClassEx(kVs, kVsImageNoiseBlock, kPxBlock)

kVsFx(const kChar*) kVsImageNoiseBlock_VDescription();
kVsFx(kStatus) kVsImageNoiseBlock_VOnSetup(kVsImageNoiseBlock block);
kVsFx(kStatus) kVsImageNoiseBlock_VOnStart(kVsImageNoiseBlock block);
kVsFx(kStatus) kVsImageNoiseBlock_VOnReceive(kVsImageNoiseBlock block, kPxPort port, kMsgSet msg);
kVsFx(kStatus) kVsImageNoiseBlock_VOnStop(kVsImageNoiseBlock block);

kVsFx(kStatus) kVsImageNoiseBlock_ValidateInfo(kVsImageNoiseBlock block, kVsImageNoiseBlockInfo info);
kVsFx(kStatus) kVsImageNoiseBlock_DefaultInfo(kVsImageNoiseBlock block, kVsImageNoiseBlockInfo info);
kStatus kVsImageNoiseBlock_FreeSamples(kVsImageNoiseBlock block);

kVsFx(k64f) kVsImageNoiseBlock_AverageTemperature(kVsImageNoiseBlock block, kArrayList messages);

#endif /* #ifndef LMITECH_KVISION_L3D_ZIMAGE_NOISEBLOCK_H_INCLUDED */
