#ifndef kVS_ANALOG_ADJUST_ACTION_X_H
#define kVS_ANALOG_ADJUST_ACTION_X_H


#include <kApi/kApi.h>
#include <kVision/Vs/kVsDef.h>
#include <kFireSync/Action/kAxAction.h>
#include <kFireSync/Client/kNode.h>
#include <kVision/Common/kVision.h>
#include <kVision/Vs/kVsAnalogAdjustActionOutput.h>

typedef struct kVsAnalogAdjustActionClass
{
    kAxActionClass base;
    kVsAnalogAdjustActionOutputCorrectionMethod status;
} kVsAnalogAdjustActionClass;

kDeclareClassEx(kVs, kVsAnalogAdjustAction, kAxAction)


kVsFx(const kChar*) kVsAnalogAdjustAction_VDescription();
kVsFx(kStatus) kVsAnalogAdjustAction_VValidate(kXml settings, kAlloc alloc);


/**
* Invokes the Analog Adjust action.  This loads the analog adjust file and applies the correction (see the action's .h file for a description).
*
* @public               @memberof kVsAnalogAdjustAction
* @param   action       The previously constructed action.
* @param   input        Use kNULL, this is ignored by this action.
* @param   output       If it is not kNULL, it will return a kXml object.  This xml will have a single parameter indicating what was loaded.   
*                       The kVsAnalogAdjustActionOutput class can be used for reading this xml.
* @param   alloc        Memory allocator (or kNULL for default).
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjustAction_VInvoke(kVsAnalogAdjustAction action, kObject input, kObject* output, kAlloc alloc);
kVsFx(kStatus) kVsAnalogAdjustAction_LoadAnalogAdjust(kVsAnalogAdjustAction action, kNode node);
kVsFx(kStatus) kVsAnalogAdjustAction_LoadAdjustXml(kVsAnalogAdjustAction action, kNode node);
kVsFx(kStatus) kVsAnalogAdjustAction_ResetCalibration(kVsAnalogAdjustAction action, kNode node);

#endif
