/** 
 * @file    kVsAdaptiveNorm.x.h
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_VISION_ADAPTIVE_NORM_X_H
#define K_VISION_ADAPTIVE_NORM_X_H

#include <kVision/Common/kVision.h>

/**
* Default filter parameter settings.
*
* @relates        kVsAdaptiveNorm
* @{ */
#define kVS_ADAPTIVE_NORM_DEFAULT_FILTER_CAP                (127)
#define kVS_ADAPTIVE_NORM_DEFAULT_MIN_CONTRAST              (5)
/** @} */

/**
* Reserved AdaptiveNorm macros.
*
* @relates        kVsAdaptiveNorm
* @{ */
#define kVS_ADAPTIVE_NORM_SQRT_LUT_SIZE                     ((256 / 4)*(256 / 4) + 1)
#define kVS_ADAPTIVE_NORM_STDEV_COUNT                       (4)
/** @} */

typedef struct kVsAdaptiveNormClass  
{
    kVsImageFilterClass base;
    kSize filterCap;
    kSize minContrast;
    kArray1 vSumSqBuffer;
    kArray1 sqrtLut;

} kVsAdaptiveNormClass;

kDeclareClassEx(kVs, kVsAdaptiveNorm, kVsImageFilter)

//semi-private exported functions (virtual override methods)
kVsFx(kStatus) kVsAdaptiveNorm_VRelease(kVsAdaptiveNorm filter);
kVsFx(kStatus) kVsAdaptiveNorm_VApply(kVsAdaptiveNorm filter, kObject input, kObject output);
kVsFx(kStatus) kVsAdaptiveNorm_VSetup(kVsAdaptiveNorm filter);

//non-exported (private) methods
kVsFx(kStatus) kVsAdaptiveNorm_Init(kVsAdaptiveNorm filter, kType type, kAlloc allocator);
kVsFx(kType) kVsAdaptiveNorm_DetermineSumSqType(kType dataType);
kVsFx(kStatus) kVsAdaptiveNorm_Apply16s(kVsAdaptiveNorm filter, const k16s* v, k16s* vOut, kSSize height, kSSize stride);
kVsFx(kStatus) kVsAdaptiveNorm_Apply32s(kVsAdaptiveNorm filter, const k32s* v, k32s* vOut, kSSize height, kSSize stride);
kVsFx(kStatus) kVsAdaptiveNorm_Apply8u(kVsAdaptiveNorm filter, const k8u* v, k8u* vOut, kSSize height, kSSize stride);
kVsFx(kStatus) kVsAdaptiveNorm_Apply64f(kVsAdaptiveNorm filter, const k64f* v, k64f* vOut, kSSize height, kSSize stride);

//cast macro

#endif   /* #ifndef K_VISION_ADAPTIVE_NORM_X_H */

