#ifndef LMITECH_KVISION_S3D_UTILITIES_X_H_INCLUDED
#define LMITECH_KVISION_S3D_UTILITIES_X_H_INCLUDED

//////////////////////////////////////////////////////////////////////////
// Inline
//////////////////////////////////////////////////////////////////////////

kCudaInlineFx(k64u) kS3dMath_SqrDistancePoint3d16s(const kPoint3d16s *point0, const kPoint3d16s *point1)
{
    const k64s dx = point0->x - point1->x;
    const k64s dy = point0->y - point1->y;
    const k64s dz = point0->z - point1->z;

    return (k64u)(dx * dx + dy * dy + dz * dz);
}

//////////////////////////////////////////////////////////////////////////
// Inline
//////////////////////////////////////////////////////////////////////////

kInlineFx(kPoint3d16s) kS3dMath_LinearInterpolationPoint3d16s(const kPoint3d16s *point0, const kPoint3d16s *point1, k32u fraction)
{
    kPoint3d16s point;

    point.x = (k16s)((k32s)point0->x + ((fraction * ((k32s)point1->x - (k32s)point0->x)) >> 16));
    point.y = (k16s)((k32s)point0->y + ((fraction * ((k32s)point1->y - (k32s)point0->y)) >> 16));
    point.z = (k16s)((k32s)point0->z + ((fraction * ((k32s)point1->z - (k32s)point0->z)) >> 16));

    return point;
}

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#endif /* #ifndef LMITECH_KVISION_S3D_UTILITIES_X_H_INCLUDED */
