/**
 * @file    kS3dSurfaceResampleBlockInfo.h
 * @brief   Declares the kS3dSurfaceResampleBlockInfo class.
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef LMITECH_KVISION_S3D_SURFACE_RESAMPLE_BLOCK_INFO_H
#define LMITECH_KVISION_S3D_SURFACE_RESAMPLE_BLOCK_INFO_H

#include <kVision/Common/kVision.h>

#define kS3D_SURFACE_RESAMPLE_BLOCK_NAME                    "kS3dSurfaceResampleBlock"
#define kS3D_SURFACE_RESAMPLE_BLOCK_TYPE_NAME               "kS3dSurfaceResampleBlock"

#define kS3D_SURFACE_RESAMPLE_BLOCK_IN_SURFACE_NAME         "InSurface"
#define kS3D_SURFACE_RESAMPLE_BLOCK_IN_INTENSITY_NAME       "InIntensity"
#define kS3D_SURFACE_RESAMPLE_BLOCK_OUT_SURFACE_NAME        "OutSurface"
#define kS3D_SURFACE_RESAMPLE_BLOCK_OUT_INTENSITY_NAME      "OutIntensity"

#define kS3D_SURFACE_RESAMPLE_BLOCK_XY_THRESHOLD_DEFAULT    (4.0)   // multiplied by x/y step
#define kS3D_SURFACE_RESAMPLE_BLOCK_Z_THRESHOLD_DEFAULT     (20.0)  // multiplied by max of x step / y step

#define kS3D_SURFACE_RESAMPLE_BLOCK_IN_SURFACE              (0)
#define kS3D_SURFACE_RESAMPLE_BLOCK_IN_INTENSITY            (1)
#define kS3D_SURFACE_RESAMPLE_BLOCK_OUT_SURFACE             (1000)
#define kS3D_SURFACE_RESAMPLE_BLOCK_OUT_INTENSITY           (1001)

typedef kObject kS3dSurfaceResampleBlockInfo;

kDeclareClassEx(kVs, kS3dSurfaceResampleBlockInfo, kObject)

kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_Construct(kS3dSurfaceResampleBlockInfo* info, kAlloc alloc);
kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_Load(kS3dSurfaceResampleBlockInfo* info, kXml xml, kAlloc alloc);
kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_Store(kS3dSurfaceResampleBlockInfo info, kXml* xml);

kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_Read(kS3dSurfaceResampleBlockInfo info, kXml xml, kXmlItem item);
kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_Write(kS3dSurfaceResampleBlockInfo info, kXml xml, kXmlItem item);

kVsFx(kBool) kS3dSurfaceResampleBlockInfo_CudaEnabled(kS3dSurfaceResampleBlockInfo info);
kVsFx(k64f) kS3dSurfaceResampleBlockInfo_XResolution(kS3dSurfaceResampleBlockInfo info);
kVsFx(k64f) kS3dSurfaceResampleBlockInfo_YResolution(kS3dSurfaceResampleBlockInfo info);
kVsFx(k64f) kS3dSurfaceResampleBlockInfo_ZResolution(kS3dSurfaceResampleBlockInfo info);
kVsFx(const kRect3d64f*) kS3dSurfaceResampleBlockInfo_FovRect(kS3dSurfaceResampleBlockInfo info);
kVsFx(const kPoint3d64f*) kS3dSurfaceResampleBlockInfo_DataOrigin(kS3dSurfaceResampleBlockInfo info);
kVsFx(k64f) kS3dSurfaceResampleBlockInfo_XStepOut(kS3dSurfaceResampleBlockInfo info);
kVsFx(k64f) kS3dSurfaceResampleBlockInfo_YStepOut(kS3dSurfaceResampleBlockInfo info);
kVsFx(k64f) kS3dSurfaceResampleBlockInfo_XYThreshold(kS3dSurfaceResampleBlockInfo info);
kVsFx(k64f) kS3dSurfaceResampleBlockInfo_ZThreshold(kS3dSurfaceResampleBlockInfo info);
kVsFx(k32s) kS3dSurfaceResampleBlockInfo_InWidth(kS3dSurfaceResampleBlockInfo info);
kVsFx(k32s) kS3dSurfaceResampleBlockInfo_InHeight(kS3dSurfaceResampleBlockInfo info);
kVsFx(k32s) kS3dSurfaceResampleBlockInfo_Quadrant(kS3dSurfaceResampleBlockInfo info);
kVsFx(k32s) kS3dSurfaceResampleBlockInfo_FlipCoordinates(kS3dSurfaceResampleBlockInfo info);
kVsFx(k32s) kS3dSurfaceResampleBlockInfo_ThreadCount(kS3dSurfaceResampleBlockInfo info);

kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_EnableCuda(kS3dSurfaceResampleBlockInfo info, kBool enabled);
kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_SetXResolution(kS3dSurfaceResampleBlockInfo info, k64f resolution);
kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_SetYResolution(kS3dSurfaceResampleBlockInfo info, k64f resolution);
kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_SetZResolution(kS3dSurfaceResampleBlockInfo info, k64f resolution);
kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_SetFovRect(kS3dSurfaceResampleBlockInfo info, const kRect3d64f* rect);
kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_SetDataOrigin(kS3dSurfaceResampleBlockInfo info, const kPoint3d64f* dataOrigin);
kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_SetXStepOut(kS3dSurfaceResampleBlockInfo info, k64f step);
kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_SetYStepOut(kS3dSurfaceResampleBlockInfo info, k64f step);
kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_SetXYThreshold(kS3dSurfaceResampleBlockInfo info, k64f step);
kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_SetZThreshold(kS3dSurfaceResampleBlockInfo info, k64f step);
kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_SetInWidth(kS3dSurfaceResampleBlockInfo info, k32s inWidth);
kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_SetInHeight(kS3dSurfaceResampleBlockInfo info, k32s inHeight);
kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_SetQuadrant(kS3dSurfaceResampleBlockInfo info, k32s quadrant);
kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_SetFlipCoordinates(kS3dSurfaceResampleBlockInfo info, kBool flipCoordinates);
kVsFx(kStatus) kS3dSurfaceResampleBlockInfo_SetThreadCount(kS3dSurfaceResampleBlockInfo info, k32s threadCount);

#endif
