#ifndef LMITECH_KVISION_S3D_STRIPEBLOCKINFO_H_INCLUDED
#define LMITECH_KVISION_S3D_STRIPEBLOCKINFO_H_INCLUDED

#include <kVision/S3d/kS3dCommon.h>
#include <kVision/L3d/kL3dTransform3d.h>

#define kS3D_STRIPE_BLOCK_NAME                 "Stripe"
#define kS3D_STRIPE_BLOCK_TYPE_NAME            "kS3dStripeBlock"

#define kS3D_STRIPE_BLOCK_INIMAGE_NAME         "InImage"
#define kS3D_STRIPE_BLOCK_OUTPLOT_NAME         "OutPlot"
#define kS3D_STRIPE_BLOCK_OUTRANGES_NAME       "OutRanges"
#define kS3D_STRIPE_BLOCK_OUTDIAG_NAME         "OutDiag"
#define kS3D_STRIPE_BLOCK_OUTMESH_NAME         "OutMesh"
#define kS3D_STRIPE_BLOCK_OUTMAP_NAME          "OutMap"

typedef enum
{
    kS3D_STRIPE_BLOCK_INIMAGE0   = 0,
    kS3D_STRIPE_BLOCK_INIMAGE1   = 1,
    kS3D_STRIPE_BLOCK_OUTRANGES  = 2,
    kS3D_STRIPE_BLOCK_OUTPLOT0   = 3,
    kS3D_STRIPE_BLOCK_OUTPLOT1   = 4,
    kS3D_STRIPE_BLOCK_OUTDIAG   =  5,
    kS3D_STRIPE_BLOCK_OUTMESH   =  6,
    kS3D_STRIPE_BLOCK_OUTMAP    =  7
} StripeBlockPort;

typedef kPointer kS3dStripeBlockInfo;

kVsFx(kStatus) kS3dStripeBlockInfo_Construct(kS3dStripeBlockInfo * info);
kVsFx(kStatus) kS3dStripeBlockInfo_Load(kS3dStripeBlockInfo * info, kXml xml);
kVsFx(kStatus) kS3dStripeBlockInfo_Destroy(kS3dStripeBlockInfo info);
kVsFx(kStatus) kS3dStripeBlockInfo_Store(kS3dStripeBlockInfo info, kXml* xml);

kVsFx(kStatus) kS3dStripeBlockInfo_Read(kS3dStripeBlockInfo info, kXml xml, kXmlItem item);
kVsFx(kStatus) kS3dStripeBlockInfo_Write(kS3dStripeBlockInfo info, kXml xml, kXmlItem item);

kVsFx(kStatus) kS3dStripeBlockInfo_SetCalFileName(kS3dStripeBlockInfo info, const kChar* name);
kVsFx(kStatus) kS3dStripeBlockInfo_SetFov(kS3dStripeBlockInfo info, const kRect3d64f* fov);
kVsFx(kStatus) kS3dStripeBlockInfo_SetRoi(kS3dStripeBlockInfo info, const kRect3d64f* roi);
kVsFx(kStatus) kS3dStripeBlockInfo_SetTransform(kS3dStripeBlockInfo info, const kL3dTransform3d* transform);
kVsFx(kStatus) kS3dStripeBlockInfo_SetWindow0(kS3dStripeBlockInfo info, const kL3dCameraWindow* window);
kVsFx(kStatus) kS3dStripeBlockInfo_SetWindow1(kS3dStripeBlockInfo info, const kL3dCameraWindow* window);

kVsFx(kStatus) kS3dStripeBlockInfo_SetYSampleBegin(kS3dStripeBlockInfo info, k64f begin);
kVsFx(kStatus) kS3dStripeBlockInfo_SetYSampleSpan(kS3dStripeBlockInfo info, k64f span);
kVsFx(kStatus) kS3dStripeBlockInfo_SetRangeResolution(kS3dStripeBlockInfo info, k64f resolution);
kVsFx(kStatus) kS3dStripeBlockInfo_SetSamplingResolution(kS3dStripeBlockInfo info, k64f resolution);
kVsFx(kStatus) kS3dStripeBlockInfo_SetStripePatternCount(kS3dStripeBlockInfo info, k32u stripeCount);
kVsFx(kStatus) kS3dStripeBlockInfo_SetPhasePatternCount(kS3dStripeBlockInfo info, k32u phaseCount);
kVsFx(kStatus) kS3dStripeBlockInfo_SetPhaseSampleCount(kS3dStripeBlockInfo info, k32u sampleCount);
kVsFx(kStatus) kS3dStripeBlockInfo_SetPhaseThreshold(kS3dStripeBlockInfo info, k32u threshold);
kVsFx(kStatus) kS3dStripeBlockInfo_SetStripeThreshold(kS3dStripeBlockInfo info, k32u threshold);
kVsFx(kStatus) kS3dStripeBlockInfo_SetRoiLineCount(kS3dStripeBlockInfo info, k32u lineCount);
kVsFx(kStatus) kS3dStripeBlockInfo_SetRoiStartLine(kS3dStripeBlockInfo info, k32u startLine);

kVsFx(kStatus) kS3dStripeBlockInfo_SetLookupType(kS3dStripeBlockInfo info, k32u lookupType);
kVsFx(kStatus) kS3dStripeBlockInfo_RetainImages(kS3dStripeBlockInfo info, kBool retain);
kVsFx(kStatus) kS3dStripeBlockInfo_SetPhaseMergeThreshold(kS3dStripeBlockInfo info, k64f threshold);

kVsFx(const kChar*) kS3dStripeBlockInfo_CalFileName(kS3dStripeBlockInfo info);
kVsFx(const kRect3d64f*) kS3dStripeBlockInfo_Fov(kS3dStripeBlockInfo info);
kVsFx(const kRect3d64f*) kS3dStripeBlockInfo_Roi(kS3dStripeBlockInfo info);
kVsFx(const kL3dTransform3d*) kS3dStripeBlockInfo_Transform(kS3dStripeBlockInfo info);
kVsFx(const kL3dCameraWindow*) kS3dStripeBlockInfo_Window0(kS3dStripeBlockInfo info);
kVsFx(const kL3dCameraWindow*) kS3dStripeBlockInfo_Window1(kS3dStripeBlockInfo info);

kVsFx(k64f) kS3dStripeBlockInfo_YSampleBegin(kS3dStripeBlockInfo info);
kVsFx(k64f) kS3dStripeBlockInfo_YSampleSpan(kS3dStripeBlockInfo info);
kVsFx(k64f) kS3dStripeBlockInfo_RangeResolution(kS3dStripeBlockInfo info);
kVsFx(k64f) kS3dStripeBlockInfo_SamplingResolution(kS3dStripeBlockInfo info);
kVsFx(k32u) kS3dStripeBlockInfo_StripePatternCount(kS3dStripeBlockInfo info);
kVsFx(k32u) kS3dStripeBlockInfo_PhasePatternCount(kS3dStripeBlockInfo info);
kVsFx(k32u) kS3dStripeBlockInfo_PhaseSampleCount(kS3dStripeBlockInfo info);
kVsFx(k32u) kS3dStripeBlockInfo_PhaseThreshold(kS3dStripeBlockInfo info);
kVsFx(k32u) kS3dStripeBlockInfo_StripeThreshold(kS3dStripeBlockInfo info);
kVsFx(k32u) kS3dStripeBlockInfo_RoiLineCount(kS3dStripeBlockInfo info);
kVsFx(k32u) kS3dStripeBlockInfo_RoiStartLine(kS3dStripeBlockInfo info);
kVsFx(kBool) kS3dStripeBlockInfo_ImagesRetained(kS3dStripeBlockInfo info);
kVsFx(k32u) kS3dStripeBlockInfo_LookupType(kS3dStripeBlockInfo info);
kVsFx(k64f) kS3dStripeBlockInfo_PhaseMergeThreshold(kS3dStripeBlockInfo info);

#endif /* #ifndef LMITECH_KVISION_S3D_STRIPEBLOCKINFO_H_INCLUDED */
