/**
* @file    kS3dSgbm.h
* @brief   Declares the kS3dSgbm class.
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef KS3D_SPECKLE_MATCH_ALG_SGBM_H
#define KS3D_SPECKLE_MATCH_ALG_SGBM_H

#include <kVision/Common/kVision.h>
#include <kVision/S3d/kS3dSpeckleMatchAlg.h>

/**
* @class       kS3dSgbm
* @extends     kS3dSpeckleMatchAlg
* @ingroup     kVision-S3d
* @brief       Implement Semi Global Block Matching algorithm. The implementation is heavily based on OpenCV SGBM
*              codebase. 
*
*/
typedef kS3dSpeckleMatchAlg kS3dSgbm;

/**
* Constructs a SGBM algorithm object
*
* @public              @memberof kS3dSpeckleMatchAlg
* @param   alg         Destination for the constructed object handle.
* @param   allocator   Memory allocator (or kNULL for default).
* @return              Operation status.
*/
kVsFx(kStatus) kS3dSgbm_Construct(kS3dSgbm* alg, kAlloc alloc);

#include <kVision/S3d/kS3dSgbm.x.h>

#endif  /* KS3D_SPECKLE_MATCH_ALG_SGBM_H */
