#ifndef kS3D_SCAN_RESULT_X_H
#define kS3D_SCAN_RESULT_X_H

#include <kApi/Data/kArray1.h>
#include <kApi/Data/kArray2.h>
#include <kApi/Data/kArrayList.h>
#include <kApi/Data/kImage.h>
#include <kVision/S3d/kS3dUtilities.h>

#define kS3D_SCAN_INPUT_CAMERA_COUNT  (2)

typedef struct kS3dScanResultClass
{
    kObjectClass base;
    kAlloc alloc;

    kText256 name;
    k32s lookupType;
    k64f rangeResolution;

    kArray2 points64f;
    kArray2 points16s;
    kArray2 heightMap;

} kS3dScanResultClass;

kDeclareClassEx(kVs, kS3dScanResult, kObject)

kVsFx(kStatus) kS3dScanResult_VRelease(kS3dScanResult result);
kStatus kS3dScanResult_Init(kS3dScanResult result, kAlloc allocator);
kStatus kS3dScanResult_Release(kS3dScanResult result);

kVsFx(kStatus) kS3dScanResult_Read(kS3dScanResult result, kDataTree tree, kDataTreeItem item);
kVsFx(kStatus) kS3dScanResult_Write(kS3dScanResult result, kDataTree tree, kDataTreeItem item);

#endif /* #ifndef kS3D_SCAN_RESULT_X_H */
