/**
* @file    kS3dPhaseViewProcessor.x.h
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef kS3D_PHASE_VIEW_PROCESSOR_X_H
#define kS3D_PHASE_VIEW_PROCESSOR_X_H

#define kS3D_PHASE_VIEW_PROCESSOR_REFERENCE_MAX_COUNT   (1)
#define kS3d_PHASE_VIEW_PROCESSOR_HIGH_FREQ_WINDOW_SIZE (5)

//Mai: threshold for phase correction
#define kS3D_PHASE_CORRECTION_DEFAULT_CONTRAST_THRESHOLD     (1)

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

typedef struct kS3dPhaseViewProcessorExecutionTime
{
    kSize timeStripe;
    kSize timePhase;

    kSize timeCombine;
    kSize timePhaseFilter;
    kSize timeSample;

} kS3dPhaseViewProcessorExecutionTime;

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

typedef struct kS3dPhaseViewProcessorClass
{
    kObjectClass base;

    kS3dStereoProfiler profiler;
    kSize viewIndex;

    kBool retainInput;
    kBool cudaEnabled;
    kBool cudaManagedMemoryEnabled;

    // Algorithm parameters
    kBool imageInputEnabled;    

    kSize imageWidth;
    kSize imageHeight; 

    // Stripe //
    kSize referenceImageCount;
    kSize stripeImageCount;
    kSize phaseImageCount;

    // EPS //
    kArray1 embeddedPhaseCoefficients; // k64f
    kArray1 embeddedPhaseImageCounts;  // kSize

    kS3dEncodeType encodeType; // Stripe, EPS

    // //
    kSize sequenceCount;
    kSize intensitySequenceIndex;

    kSize phaseContrastThreshold;
    kSize stripeContrastThreshold;

    kSize phasePeriod;
    kSize phaseBegin;
    kSize phaseStepShift;
    kSize outputHeight;

    kSSize ySampleBegin;
    kSize ySampleStep;
    kSize outputWidth;

    kSize erosionMargin;

    kS3dPhaseCorrectionType phaseCorrectionType;

    //Internal data
    kS3dStripeDecoder stripeDecoder;   // NULL if imageInputEnabled is false
    kS3dPhaseDecoder phaseDecoder;     // NULL if imageInputEnabled is false
    kS3dEmbeddedPhaseDecoder embeddedPhaseDecoder;
    
    kS3dPhaseCombiner combiner;
    kS3dPhaseFilter filter;
    kS3dPhaseCorrection phaseCorrection;
    kS3dPhaseSampler sampler;
    kVsJobQueue jobQueue;

    kArray2 sequenceStripeMap;
    kArray2 sequencePhaseMap;
    kArray2 cudaPhaseMapCombined;
    kArray2 phaseMapCombined;

    kCudaStream cudaStream;

    kSize sequenceImageCount;
    kSize sequenceImageReceivedCount;

    //Execution timing
    kTimer timer;
    kS3dPhaseViewProcessorExecutionTime executionTime;

    //Outputs //
    kArray2 outputXProj;
    kArray2 outputIntensity;
    kArray2 outputTexture;    

} kS3dPhaseViewProcessorClass;

kDeclareClassEx(kVs, kS3dPhaseViewProcessor, kObject)

//////////////////////////////////////////////////////////////////////////
//semi-private exported functions (virtual override methods)
//////////////////////////////////////////////////////////////////////////

kVsFx(kStatus) kS3dPhaseViewProcessor_VInitClone(kS3dPhaseViewProcessor processor, kS3dPhaseViewProcessor source, kAlloc allocator);
kVsFx(kStatus) kS3dPhaseViewProcessor_VRelease(kS3dPhaseViewProcessor processor);
kVsFx(kSize)   kS3dPhaseViewProcessor_VSize(kS3dPhaseViewProcessor processor);

//non-exported (private) methods
kStatus kS3dPhaseViewProcessor_Init(kS3dPhaseViewProcessor processor, kSize viewIndex, kS3dStereoProfiler profiler, kAlloc allocator);

//semi-private methods (API can change any time)
kVsFx(kStatus) kS3dPhaseViewProcessor_SetJobQueue(kS3dPhaseViewProcessor processor, kVsJobQueue queue);

kVsFx(const kS3dPhaseViewProcessorExecutionTime*)  kS3dPhaseViewProcessor_ExecutionTime(kS3dPhaseViewProcessor processor);
kStatus kS3dPhaseViewProcessor_StartTimer(kS3dPhaseViewProcessor processor);
kSize kS3dPhaseViewProcessor_Elapsed(kS3dPhaseViewProcessor processor);

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kStatus kS3dPhaseViewProcessor_SetupStripePhaseDecoder(kS3dPhaseViewProcessor processor);
kStatus kS3dPhaseViewProcessor_SetupEmbeddedPhaseDecoder(kS3dPhaseViewProcessor processor);

kStatus kS3dPhaseViewProcessor_UpdateImageStripePhase(kS3dPhaseViewProcessor processor, kImage image);
kStatus kS3dPhaseViewProcessor_UpdateImageEmbeddedPhase(kS3dPhaseViewProcessor processor, kImage image);

kBool kS3dPhaseViewProcessor_DecoderIsComplete(kS3dPhaseViewProcessor processor);

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kStatus kS3dPhaseViewProcessor_End(kS3dPhaseViewProcessor processor, kArray2 phaseMap);

//////////////////////////////////////////////////////////////////////////
//cast macro
//////////////////////////////////////////////////////////////////////////

#endif  /* #ifndef kS3D_PHASE_VIEW_PROCESSOR_X_H */
