#ifndef LMITECH_KVISION_S3D_PHASEALG_H_INCLUDED
#define LMITECH_KVISION_S3D_PHASEALG_H_INCLUDED

#include <kVision/S3d/kS3dCommon.h>
#include <kVision/S3d/kS3dStereoCal.h>
#include <kFireSync/Data/kPlot.h>

typedef kPointer kS3dPhaseAlg;

typedef struct kS3dPhaseAlgParams 
{
    k32u imageWidth;
    k32u imageHeight;
    k32u sequenceCount;
    
    k32u referencePatternCount;
    k32u stripePatternCount;
    k32u phasePatternCount;
    
    k32u phaseSampleCount;
    k32u intensitySequenceIndex;

    k32u phaseThreshold;
    k32u stripeThreshold;

    k32u roiStartStripe;
    k32u roiStripeCount;

    kBool retainImages;

    k32u phaseScale;
    k32u sineLutShift;

    kBool wide;

} kS3dPhaseAlgParams;

typedef struct kS3dPhaseAccum 
{
    k32s dx;
    k32s dy;
    
    k8u minValue;
    k8u maxValue;
    k16u sum;
    k8u contrast;

} kS3dPhaseAccum;

typedef struct kS3dCodeAccum 
{
    k8u code;
} kS3dCodeAccum;

typedef struct kS3dMapPixel 
{
    k8u code;
    k16s phase;
} kS3dMapPixel;

kVsFx(kStatus) kS3dPhaseAlg_Construct(kS3dPhaseAlg* alg, const kS3dPhaseAlgParams* params);
kVsFx(kStatus) kS3dPhaseAlg_Destroy(kS3dPhaseAlg alg);

kVsFx(kStatus) kS3dPhaseAlg_UpdateRoi(kS3dPhaseAlg alg, kSize imageWidth, kSize imageHeight, kSize startStripe, kSize stripeCount);
kVsFx(kStatus) kS3dPhaseAlg_Reset(kS3dPhaseAlg alg);

kVsFx(kStatus) kS3dPhaseAlg_SetPhaseSmoothWindow(kS3dPhaseAlg alg, k32u window);
kVsFx(k32u) kS3dPhaseAlg_PhaseSmoothWindow(kS3dPhaseAlg alg);

kVsFx(kStatus) kS3dPhaseAlg_Update(kS3dPhaseAlg alg, kImage image);
kVsFx(kBool)   kS3dPhaseAlg_SequenceComplete(kS3dPhaseAlg alg);
kVsFx(kBool)   kS3dPhaseAlg_ScanComplete(kS3dPhaseAlg alg);

kVsFx(kStatus) kS3dPhaseAlg_FilterCodeMap(kS3dPhaseAlg alg);
kVsFx(kStatus) kS3dPhaseAlg_FillCodeMap(kS3dPhaseAlg alg);
kVsFx(kStatus) kS3dPhaseAlg_SnapCodeMap(kS3dPhaseAlg alg);

kVsFx(kStatus) kS3dPhaseAlg_StripePlot(kS3dPhaseAlg alg, kSize stripeFrameIndex, kPlot* plot);
kVsFx(kStatus) kS3dPhaseAlg_RowPlot(kS3dPhaseAlg alg, kSize rowIndex, kPlot* plot);
kVsFx(kStatus) kS3dPhaseAlg_PhaseDeltaPlot(kS3dPhaseAlg alg, kPlot* delta);

kVsFx(kArray2) kS3dPhaseAlg_PhaseMap(kS3dPhaseAlg alg);
kVsFx(kArray2) kS3dPhaseAlg_PhaseAccum(kS3dPhaseAlg alg);
kVsFx(kArray2) kS3dPhaseAlg_CodeAccum(kS3dPhaseAlg alg);

kVsFx(kStatus) kS3dPhaseAlg_ScalePhase(kS3dPhaseAlg alg, k32s shift);

kVsFx(kStatus) kS3dPhaseAlg_PhaseImage(kS3dPhaseAlg alg, kImage* image);
kVsFx(kStatus) kS3dPhaseAlg_CodeImage(kS3dPhaseAlg alg, kImage* image);

kVsFx(kImage) kS3dPhaseAlg_Reference(kS3dPhaseAlg alg);

kVsFx(kImage) kS3dPhaseAlg_ReferenceImageAt(kS3dPhaseAlg alg, kSize index);
kVsFx(kImage) kS3dPhaseAlg_StripeImageAt(kS3dPhaseAlg alg, kSize index);
kVsFx(kImage) kS3dPhaseAlg_PhaseImageAt(kS3dPhaseAlg alg, kSize index);
kVsFx(kImage) kS3dPhaseAlg_ImageAt(kS3dPhaseAlg alg, kSize index);

kVsFx(k64s) kS3dPhaseAlg_ReferenceTime(kS3dPhaseAlg alg);
kVsFx(k64s) kS3dPhaseAlg_StripeTime(kS3dPhaseAlg alg);
kVsFx(k64s) kS3dPhaseAlg_PhaseTime(kS3dPhaseAlg alg);

kVsFx(kSize) kS3dPhaseAlg_MemoryUsage(kS3dPhaseAlg alg);
kVsFx(kSize) kS3dPhaseAlg_ExportTestCase(kS3dPhaseAlg alg, const kChar* dstDir);

kVsFx(kStatus) kS3dPhaseAlg_Intensity(kS3dPhaseAlg alg, kArray2* intensity);

#endif /* #define LMITECH_KVISION_S3D_PHASEALG_H_INCLUDED */
