/** 
 * @file    kS3dPhaseAction.x.h
 * 
 * @internal
 * Copyright (C)  by LMI Technologies Inc. All rights reserved.
 */
#ifndef kS3D_PHASE_ACTION_X_H
#define kS3D_PHASE_ACTION_X_H

#include <kVision/S3d/kS3dPhaseActionInfo.h>
#include <kFireSync/Action/kAxAction.h>

typedef struct kS3dPhaseActionClass
{
    kAxActionClass base; 
} kS3dPhaseActionClass; 

kVsFx(const kChar*) kS3dPhaseAction_VDescription();
kVsFx(kStatus) kS3dPhaseAction_VValidate(kXml settings, kAlloc alloc);
kVsFx(kStatus) kS3dPhaseAction_VInvoke(kS3dPhaseAction action, kObject input, kObject* output, kAlloc alloc);

kVsFx(kStatus) kS3dPhaseAction_Apply(kS3dPhaseAction action, kS3dPhaseActionInfo info);

kStatus kS3dPhaseAction_DeleteExtensions(kS3dPhaseAction action, kCamera camera);

kDeclareClassEx(kVs, kS3dPhaseAction, kAxAction)

#endif
