/**
 * @file    kS3dMonoMergeRigidAlg.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kVS_MONO_MERGE_RIGID_ALG_X_H
#define kVS_MONO_MERGE_RIGID_ALG_X_H

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#define kS3D_MONO_MERGE_RIGID_DELTA_SHIFT            (15)
#define kS3D_MONO_MERGE_RIGID_DELTA_SCALE            (1 << kS3D_MONO_MERGE_RIGID_DELTA_SHIFT)

#define kS3D_MONO_MERGE_RIGID_MERGE_STEP             (8)
#define kS3D_MONO_MERGE_RIGID_MERGE_FLUSH_INTERVAL   (10000)
#define kS3D_MONO_MERGE_RIGID_MERGE_MIN_POINTS       (100)   // 100 points
#define kS3D_MONO_MERGE_RIGID_MERGE_MIN_POINTS_TOL   (0.001) // 0.1%

 //////////////////////////////////////////////////////////////////////////
 // MERGE RIGID
 // xkS3dStereoProfilerBase_LookupMapMergeRigid()
 //////////////////////////////////////////////////////////////////////////

typedef enum
{
    kS3D_DELTAN_ACCUM_U,
    kS3D_DELTAN_ACCUM_V,
    kS3D_DELTAN_ACCUM_UU,
    kS3D_DELTAN_ACCUM_VV,
    kS3D_DELTAN_ACCUM_UV,

    kS3D_DELTAN_ACCUM_DXU,
    kS3D_DELTAN_ACCUM_DXV,
    kS3D_DELTAN_ACCUM_DX,

    kS3D_DELTAN_ACCUM_DYU,
    kS3D_DELTAN_ACCUM_DYV,
    kS3D_DELTAN_ACCUM_DY,

    kS3D_DELTAN_ACCUM_DZU,
    kS3D_DELTAN_ACCUM_DZV,
    kS3D_DELTAN_ACCUM_DZ,

    kS3D_DELTAN_ACCUM_COUNT

} kS3dStereoProfilerDeltaAccum;

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

typedef struct kS3dPhaseDeltaFunction
{
    k64f accumf[kS3D_DELTAN_ACCUM_COUNT];
    k64s accum[kS3D_DELTAN_ACCUM_COUNT];

    k64u n;

    // delta plane fit coefficients

    k64f coeffsDx[3];
    k64f coeffsDy[3];
    k64f coeffsDz[3];

    k32s coeffsDxi[3];
    k32s coeffsDyi[3];
    k32s coeffsDzi[3];

} kS3dPhaseDeltaFunction;

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

typedef struct kS3dPhaseDeltaFunctionCuda
{
    k64f accumf[kS3D_DELTAN_ACCUM_COUNT];

    k64u n;
} kS3dPhaseDeltaFunctionCuda;

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

typedef struct kS3dStereoProfilerPair
{
    kPoint3d16s source;
    kPoint3d16s target;

} kS3dStereoProfilerPair;

kDeclareValueEx(kVs, kS3dStereoProfilerPair, kValue)


//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

typedef struct kS3dMonoMergeRigidAlgClass
{
    kObjectClass base;

    kS3dStereoProfiler profiler;

    kVsJobQueue jobQueue;

    kSize height;
    kSize width;

    // Merging vars //////////////////////////////////////////////////////
    kS3dPhaseDeltaFunction delta[2];
    kS3dPhaseDeltaFunction* cudaDelta[2];

    kArrayList pointPairs[2];
    kArray2 pointPairsMap[2];   // used by Cuda to offload Device samples to Host for delta processing
                                // potentially will replace pointPairs lists with those maps to be consistent with Cuda implementation
    kArray2 cudaPointPairs[2];

    k64f outlierTolerance; // average multiplier

} kS3dMonoMergeRigidAlgClass;

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kDeclareClassEx(kVs, kS3dMonoMergeRigidAlg, kObject)

//////////////////////////////////////////////////////////////////////////
//semi-private exported functions (virtual override methods)
//////////////////////////////////////////////////////////////////////////

kVsFx(kStatus) kS3dMonoMergeRigidAlg_VInitClone(kS3dMonoMergeRigidAlg alg, kS3dMonoMergeRigidAlg source, kAlloc allocator);
kVsFx(kStatus) kS3dMonoMergeRigidAlg_VRelease(kS3dMonoMergeRigidAlg alg);

//////////////////////////////////////////////////////////////////////////
//non-exported (private) methods
//////////////////////////////////////////////////////////////////////////

#if defined (K_HAVE_CUDA)
kStatus xkS3dMonoMergeRigidAlg_InitCuda(kS3dMonoMergeRigidAlg alg, kS3dStereoProfiler profiler, kAlloc allocator);
kStatus xkS3dMonoMergeRigidAlg_SetupCuda(kS3dMonoMergeRigidAlg alg);
kStatus xkS3dMonoMergeRigidAlg_ReleaseCuda(kS3dMonoMergeRigidAlg alg);

kStatus xkS3dMonoMergeRigidAlg_SamplePairsCuda(kS3dMonoMergeRigidAlg alg, kArray2 stereo, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1, kArray1 phaseTable);

kStatus xkS3dMonoMergeRigidAlg_RemoveSampleOutliersCuda(kS3dMonoMergeRigidAlg alg);

kStatus kS3dMonoMergeRigidAlg_SqrAveragePairsCuda(kS3dMonoMergeRigidAlg alg, kSize viewIndex, k64u* outSqrAverage);
kStatus xkS3dMonoMergeRigidAlg_RemovePairsCuda(kS3dMonoMergeRigidAlg alg, kSize viewIndex, k64u tol);

kStatus xkS3dMonoMergeRigidAlg_CalculatePhaseDeltaCuda(kS3dMonoMergeRigidAlg alg, kSize viewIndex);

kStatus xkS3dMonoMergeRigidAlg_FillHolesCuda(kS3dMonoMergeRigidAlg alg, kArray2 stereo, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1, kArray1 phaseTable);

#else
kInline kStatus xkS3dMonoMergeRigidAlg_InitCuda(kS3dMonoMergeRigidAlg alg, kS3dStereoProfiler profiler, kAlloc allocator) { return kOK; }
kInline kStatus xkS3dMonoMergeRigidAlg_SetupCuda(kS3dMonoMergeRigidAlg alg) { return kOK; }
kInline kStatus xkS3dMonoMergeRigidAlg_ReleaseCuda(kS3dMonoMergeRigidAlg alg) { return kOK; }
#endif

kStatus xkS3dMonoMergeRigidAlg_Init(kS3dMonoMergeRigidAlg alg, kS3dStereoProfiler profiler, kAlloc allocator);

kStatus xkS3dMonoMergeRigidAlg_SamplePairs(kS3dMonoMergeRigidAlg alg, kArray2 stereo, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1, kArray1 phaseTable);

kStatus xkS3dMonoMergeRigidAlg_CalculatePhaseDelta(kS3dMonoMergeRigidAlg alg);

kStatus xkS3dMonoMergeRigidAlg_FillHoles(kS3dMonoMergeRigidAlg alg, kArray2 stereo, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1, kArray1 phaseTable);

// solver //
kStatus xkS3dMonoMergeRigidAlg_Invert3x3(k64f* input, k64f* output);
kStatus xkS3dMonoMergeRigidAlg_SolvePhaseDelta(kS3dMonoMergeRigidAlg alg, kS3dPhaseDeltaFunction* delta);

// outliers //
kStatus xkS3dMonoMergeRigidAlg_RemoveSampleOutliers(kS3dMonoMergeRigidAlg alg);

kStatus xkS3dMonoMergeRigidAlg_SqrAveragePairs(kArrayList pairs, k64u* ave);
kStatus xkS3dMonoMergeRigidAlg_RemovePairs(kArrayList pairs, k64u tol);

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#endif  /* #ifndef kVS_MONO_MERGE_RIGID_ALG_X_H */
