/**
 * @file    kS3dMonoMergeLocalAlg.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kVS_MONO_MERGE_LOCAL_ALG_X_H
#define kVS_MONO_MERGE_LOCAL_ALG_X_H

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

// SOLVER //
#define kVS_MONO_MERGE_LOCAL_NEIGHBORS (4)

#define kVS_MONO_MERGE_LOCAL_W_LAPL (10000)
#define kVS_MONO_MERGE_LOCAL_W_SOFT (1)
#define kVS_MONO_MERGE_LOCAL_W_HARD (10000)


typedef struct kS3dMonoMergeLocalAlgClass
{
    kObjectClass base;

    k32s mergeThreshold;

    kArray2 sourceIds;

    kArray2 localCoords;
    kArray2 merge; // kPoint3d32s instead of kPoint3d16s

    kSize lineCount;
    kSize lineWidth;

    kSize expandCount;

    kSize neighRow[kVS_MONO_MERGE_LOCAL_NEIGHBORS];
    kSize neighCol[kVS_MONO_MERGE_LOCAL_NEIGHBORS];

    // Solver //
    kArrayList solverLaplasian; // [solverPatchSize + solverBoundarySize, solverPatchSize]
    kArray2 solverTarget;       // [solverPatchSize + solverBoundarySize, 3]

    kArray2 solverPatch;

    k32s solverPatchSize;


} kS3dMonoMergeLocalAlgClass;

kDeclareClassEx(kVs, kS3dMonoMergeLocalAlg, kObject)

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

//cast macro

//////////////////////////////////////////////////////////////////////////
//semi-private exported functions (virtual override methods)
//////////////////////////////////////////////////////////////////////////

kVsFx(kStatus) kS3dMonoMergeLocalAlg_VInitClone(kS3dMonoMergeLocalAlg alg, kS3dMonoMergeLocalAlg source, kAlloc allocator);
kVsFx(kStatus) kS3dMonoMergeLocalAlg_VRelease(kS3dMonoMergeLocalAlg alg);
kVsFx(kSize) kS3dMonoMergeLocalAlg_VSize(kS3dMonoMergeLocalAlg alg);

//////////////////////////////////////////////////////////////////////////
//non-exported (private) methods
//////////////////////////////////////////////////////////////////////////

kStatus kS3dMonoMergeLocalAlg_Init(kS3dMonoMergeLocalAlg alg, kAlloc allocator);

kStatus kS3dMonoMergeLocalAlg_Setup(kS3dMonoMergeLocalAlg alg, kSize lineCount, kSize lineWidth);

kStatus kS3dMonoMergeLocalAlg_SurfacePrep(kS3dMonoMergeLocalAlg alg, kArray2 stereo, kArray2 mono);

kStatus kS3dMonoMergeLocalAlg_InitSourceIds(kS3dMonoMergeLocalAlg alg, kArray2 stereo, kArray2 mono);
kStatus kS3dMonoMergeLocalAlg_ExpandSourceIds(kS3dMonoMergeLocalAlg alg, kArray2 stereo, k8s coreId, k8s expandId);
kStatus kS3dMonoMergeLocalAlg_Expand2Fill(kS3dMonoMergeLocalAlg alg);

kStatus kS3dMonoMergeLocalAlg_InitLocalCoords(kS3dMonoMergeLocalAlg alg, kArray2 stereo, kArray2 mono);

kStatus kS3dMonoMergeLocalAlg_InitPatch(kS3dMonoMergeLocalAlg alg);

kStatus kS3dMonoMergeLocalAlg_InitSolverData(kS3dMonoMergeLocalAlg alg, kArray2 stereo, kArray2 mono);

kStatus kS3dMonoMergeLocalAlg_MergeSingle(kS3dMonoMergeLocalAlg alg, kArray2 stereo, kArray2 mono);

//////////////////////////////////////////////////////////////////////////
// inline
//////////////////////////////////////////////////////////////////////////

kInlineFx(kStatus) kS3dMonoMergeLocalAlg_SetMergeThreshold(kS3dMonoMergeLocalAlg alg, k32s mergeThreshold)
{
    xkS3dMonoMergeLocalAlg_Cast(alg)->mergeThreshold = mergeThreshold;
    return kOK;
}

kInlineFx(k32s) kS3dMonoMergeLocalAlg_MergeThreshold(kS3dMonoMergeLocalAlg alg)
{
    return xkS3dMonoMergeLocalAlg_Cast(alg)->mergeThreshold;
}

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#endif  /* #ifndef kVS_MONO_MERGE_LOCAL_ALG_X_H */
