#ifndef kS3D_GRAYCODE_MEDIAN_X_H
#define kS3D_GRAYCODE_MEDIAN_X_H

#include <kVision/Vs/kVsJobQueue.h>

#define kS3D_GRAYCODEMEDIAN_DEFAULT_REPEAT 2

typedef struct kS3dGrayCodeMedianClass
{
    kObjectClass base;
    kArray2 temp;
    kArray2 data;
    kVsJobQueue jobQueue;
    k32s repeat;
    k32s imageSizeX;
    k32s imageSizeY;
} kS3dGrayCodeMedianClass;

kDeclareClassEx(kVs, kS3dGrayCodeMedian, kObject)

kVsFx(kStatus) kS3dGrayCodeMedian_VInitClone(kS3dGrayCodeMedian median, kS3dGrayCodeMedian source, kAlloc allocator);
kVsFx(kStatus) kS3dGrayCodeMedian_VRelease(kS3dGrayCodeMedian median);
kVsFx(kSize)   kS3dGrayCodeMedian_VSize(kS3dGrayCodeMedian median);

kStatus kS3dGrayCodeMedian_Init(kS3dGrayCodeMedian median, kType classType, kAlloc alloc);

kStatus kS3dGrayCodeMedian_Row(kS3dGrayCodeMedian median);
kStatus kCall kS3dGrayCodeMedian_RowHandler(kS3dGrayCodeMedian median, k64u id);
kStatus kS3dGrayCodeMedian_RowThread(kS3dGrayCodeMedian median, kSize startRow, kSize rowCount);

kStatus kS3dGrayCodeMedian_Column(kS3dGrayCodeMedian median);
kStatus kCall kS3dGrayCodeMedian_ColumnHandler(kS3dGrayCodeMedian median, k64u id);
kStatus kS3dGrayCodeMedian_ColumnThread(kS3dGrayCodeMedian median, kSize startRow, kSize rowCount);

#define kS3DGRAYCODEMEDIAN(HANDLE) ((kS3dGrayCodeMedianClass*)(HANDLE))

#endif
