/**
* @file    kS3dGeometryUtilities.h
* @brief   Declares the kS3dGeometryUtilities class. 
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_S3D_GEOMETRIYUTILITIES_H
#define KVISION_S3D_GEOMETRIYUTILITIES_H

#include <kVision/S3d/kS3dVolumeCheckDef.h>
#include <kVision/S3d/kS3dVolumeCheckUtilities.h>
#include <kApi/Threads/kTimer.h>

//#include <kVisionM3DApi/kM3dDef.h>

/**
* @class       kS3dGeometryUtilities
* @extends     kObject
* @ingroup     kVision-M3d
* @brief       Class for the internal data processing during a measurement..
*/
typedef kObject kS3dGeometryUtilities;

/**
* Constructs a kS3dGeometryUtilities object
*
* @public              @memberof kS3dGeometryUtilities
* @param   tools       Destination for the constructed object handle.
* @param   params      handle of the tools settings.
* @param   allocator   Memory allocator (or kNULL for default).
* @return              Operation status.
*/
kVsFx(kStatus) kS3dGeometryUtilities_Construct(kS3dGeometryUtilities* tools, kAlloc allocator);

kVsFx(kStatus) kS3dGeometryUtilities_Run(kS3dGeometryUtilities tools);

kVsFx(k64s) kS3dGeometryUtilities_TotalTime(kS3dGeometryUtilities tools);

kVsFx(kStatus) kS3dGeometryUtilities_SetMapSizeX(kS3dGeometryUtilities tools, k32s sizeX);

kVsFx(kStatus) kS3dGeometryUtilities_SetMapSizeY(kS3dGeometryUtilities tools, k32s sizeX);

kVsFx(kStatus) kS3dGeometryUtilities_SetMapScale(kS3dGeometryUtilities tools, kPoint3d64f scale);

kVsFx(kStatus) kS3dGeometryUtilities_SetInputData(kS3dGeometryUtilities tools, kArray2 input);

kVsFx(kStatus) kS3dGeometryUtilities_ResampleInputData(kS3dGeometryUtilities tools, k64f offset);

#include <kVision/S3d/kS3dGeometryUtilities.x.h>

#endif
