#ifndef LMITECH_KVISION_S3D_COMMON_H_INCLUDED
#define LMITECH_KVISION_S3D_COMMON_H_INCLUDED

#include <kFireSync/kFsDef.h>
#include <kVision/Common/kVision.h>

#define kS3D_PHASE_PRECISION                      (16)                            // Calibration phase data repetition resolution. 
#define kS3D_PHASE_SCALE                          (1 << kS3D_PHASE_PRECISION)
#define kS3D_PHASE_SINE_LUT_SHIFT                 (14)                            // Default precision for cosine and sine accumulator coefficients. Should be used for PL programming to ensure identical
                                                                                  // phase results to the software implementation

typedef enum
{
    kS3D_STRIPE_LOOKUP_DISPARITY = 0,
    kS3D_STRIPE_LOOKUP_MERGE_RIGID = 1,
    kS3D_STRIPE_LOOKUP_MERGE_QUADRATIC = 2,
    kS3D_STRIPE_LOOKUP_MERGE_LOCAL = 3,
    kS3D_STRIPE_LOOKUP_PHASE0 = 4,
    kS3D_STRIPE_LOOKUP_PHASE1 = 5,
    kS3D_STRIPE_LOOKUP_PHASE_DIFFERENCE = 6,
    kS3D_STRIPE_LOOKUP_PHASE_Z_DIFFERENCE = 7

} kS3dStripeLookupType;

typedef enum
{
    kS3D_STRIPE_INTENSITY_COMBINE = 0,  /* Average View 0 and View 1. If any type of profile occlusion filling is enabled, fill missing data with either View 0 of View 1*/
    kS3D_STRIPE_INTENSITY_VIEW0 = 1,    /* Strictly use intensity from View 0 */
    kS3D_STRIPE_INTENSITY_VIEW1 = 2     /* Strictly use intensity from View 1 */
} kS3dStripeIntensityType;

typedef enum
{
    kS3D_PHASE_CORRECTION_TYPE_NONE = 0,
    kS3D_PHASE_CORRECTION_TYPE_MULTI_REFLECTION = 1, 
    kS3D_PHASE_CORRECTION_TYPE_TRANSLUCENCY = 2
} kS3dPhaseCorrectionType;


typedef struct kS3dStripeSpot 
{
    k32s x;
    k32s y;
    k16s xProj;
    k16s yProj;
} kS3dStripeSpot;

typedef struct kLine3d64f 
{
    kPoint3d64f p;
    kPoint3d64f dir;
} kLine3d64f;

typedef struct kQuat 
{
    k64f w;
    k64f x;
    k64f y;
    k64f z;
} kQuat;

typedef struct kComplex 
{
    k64f real;
    k64f imag;
} kComplex;

typedef struct kPlane3d64f 
{
    kPoint3d64f p;
    kPoint3d64f norm;
} kPlane3d64f;

//uncomment to enable experimental support for additional DSP compiler directives to help with loop unrolling
//#define UNROLL_LOOPS (1)

#if defined(K_GCC)
#   define RESTRICTED __restrict
#elif defined(K_TI_CCS)
#   define RESTRICTED restrict
#elif defined(K_MSVC)
#   define RESTRICTED __restrict
#else
#   define RESTRICTED
#endif

#if defined(K_TI_BIOS)
    #ifdef UNROLL_LOOPS
    #   define kS3D_PRAGMA(X) _Pragma(#X)
    #   define LOOP_MUST_ITERATE(MIN_COUNT,MAX_COUNT,FACTOR)    kS3D_PRAGMA(MUST_ITERATE(MIN_COUNT, MAX_COUNT, FACTOR))
    #else
    #    define LOOP_MUST_ITERATE(MIN_COUNT,MAX_COUNT,FACTOR)
    #endif
#else
    #define LOOP_MUST_ITERATE(MIN_COUNT,MAX_COUNT,FACTOR)
#endif

//////////////////////////////////////////////////////////////////////////
// Decoding and pattern generations
// 
// kS3dPhaseProcessor
// kS3dPhaseViewProcessor
// kS3dEmbeddedPhaseDecoder
// kS3dPatternSequence
//////////////////////////////////////////////////////////////////////////

typedef enum
{
    kS3D_ENCODE_TYPE_STRIPE = 0,
    kS3D_ENCODE_TYPE_EMBEDDED_PHASE

} kS3dEncodeType;

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#endif /* #ifndef LMITECH_KVISION_S3D_COMMON_H_INCLUDED */
