/** 
 * @file    ${filename_header_public}}
 * @brief   Declares the ${classname} class. 
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kVS_SPOT_CROP_BLOCK_INFO_H
#define kVS_SPOT_CROP_BLOCK_INFO_H

#include <kVision/Common/kVision.h>
#include <kFireSync/kNodeDef.h>
#include <kApi/Data/kXml.h>

#define kP3D_SPOT_CROP_BLOCK_NAME                       "SpotCrop"
#define kP3D_SPOT_CROP_BLOCK_TYPE_NAME                  "kP3dSpotCropBlock"

#define kP3D_SPOT_CROP_BLOCK_IN_IMAGE_NAME             "InImage"
#define kP3D_SPOT_CROP_BLOCK_OUT_CROPPED_IMAGE_NAME    "CroppedImage"

/**
 * @class       kP3dSpotCropBlockInfo
 * @extends     kObject
 * @ingroup     kVision-P3d
 * @brief       This class contains the settings for kP3dSpotCropBlock.
 */
typedef kObject kP3dSpotCropBlockInfo;

/** 
 * Constructs a kP3dSpotCropBlockInfo object.
 *
 * @public              @memberof kP3dSpotCropBlockInfo
 * @param   info  Destination for the constructed object handle.
 * @param   allocator   Memory allocator (or kNULL for default).
 * @return              Operation status. 
 */
kVsFx(kStatus) kP3dSpotCropBlockInfo_Construct(kP3dSpotCropBlockInfo* info, kAlloc allocator);


/**
* Loads the content for an kXml object into an instance of kP3dSpotCropBlockInfo.
*
* @public              @memberof kP3dSpotCropBlockInfo
* @param   info        Info object.
* @param   xml         Receives constructed kXml object.
* @param   allocator   Memory allocator (or kNULL for default).
* @return              Operation status.
*/
kVsFx(kStatus) kP3dSpotCropBlockInfo_Load(kP3dSpotCropBlockInfo* info, kXml xml, kAlloc allocator);

/**
* Constructs a kXml object and uses it to store the content of this kP3dSpotCropBlockInfo instance.
*
* @public              @memberof kP3dSpotCropBlockInfo
* @param   info        Info object.
* @param   xml         Receives constructed kXml object.
* @param   allocator   Memory allocator (or kNULL for default).
* @return              Operation status.
*/
kVsFx(kStatus) kP3dSpotCropBlockInfo_Store(kP3dSpotCropBlockInfo info, kXml* xml, kAlloc allocator);

/**
* Reads kForwardBlockInfo state from a kXml object.
*
* @public              @memberof kP3dSpotCropBlockInfo
* @param   info        Info object.
* @param   xml         XML object.
* @param   item        XML item.
* @return              Operation status.
*/
kVsFx(kStatus) kP3dSpotCropBlockInfo_Read(kP3dSpotCropBlockInfo info, kXml xml, kXmlItem item);

/**
* Writes kForwardBlockInfo state to a kXml object.
*
* @public              @memberof kP3dSpotCropBlockInfo
* @param   info        Info object.
* @param   xml         XML object.
* @param   item        XML item.
* @return              Operation status.
*/
kVsFx(kStatus)kP3dSpotCropBlockInfo_Write(kP3dSpotCropBlockInfo info, kXml xml, kXmlItem item);

/**
* Checks and automatically corrects all state variables.
*
* @public              @memberof kForwardBlockInfo
* @param   info        Info object.
* @return              Operation status.
*/
kVsFx(kStatus) kP3dSpotCropBlockInfo_Validate(kP3dSpotCropBlockInfo info);

/**
* Resets all state variables to default values.
*
* @public              @memberof kForwardBlockInfo
* @param   info        Info object.
* @return              Operation status.
*/
kVsFx(kStatus) kP3dSpotCropBlockInfo_Clear(kP3dSpotCropBlockInfo info);

/**
* Sets minRunLength, which is the minimum length of a segment for it to be considered part of the spot. Smaller segments will be ignored.
*
* @public              @memberof kForwardBlockInfo
* @param   info        Info object.
* @param   length      The new value for minRunLength.
* @return              Operation status.
*/
kVsFx(kStatus)kP3dSpotCropBlockInfo_SetMinRunLength(kP3dSpotCropBlockInfo info, k32u length);

/**
* Returns the minRunLength, which is the minimum length of a segment for it to be considered part of the spot. Smaller segments will be ignored.
*
* @public              @memberof kForwardBlockInfo
* @param   info        Info object.
* @return              minRunLength.
*/
kVsFx(kSize) kP3dSpotCropBlockInfo_MinRunLength(kP3dSpotCropBlockInfo info);

/**
* Sets spotThreshold, which is the threshold for binarizing the spot image. 
*
* @public              @memberof kForwardBlockInfo
* @param   info        Info object.
* @param   threshold   The new value for threshold.
* @return              Operation status.
*/
kVsFx(kStatus)kP3dSpotCropBlockInfo_SetSpotThreshold(kP3dSpotCropBlockInfo info, k32u threshold);


/**
* Returns spotThreshold, which is the threshold for binarizing the spot image.
*
* @public              @memberof kForwardBlockInfo
* @param   info        Info object.
* @return              spotThreshold.
*/
kVsFx(kSize) kP3dSpotCropBlockInfo_SpotThreshold(kP3dSpotCropBlockInfo info);

/**
* Sets roiInflatePercent. SpotCropBlock detects the spot area, expands that area by roiInflatePercent and crops out the resulting region.
*
* @public              @memberof kForwardBlockInfo
* @param   info        Info object.
* @param   perc        The new value for roiInflatePercent.
* @return              Operation status.
*/
kVsFx(kStatus)kP3dSpotCropBlockInfo_SetRoiInflatePercent(kP3dSpotCropBlockInfo info, k32u perc);

/**
* Returns roiInflatePercent. SpotCropBlock detects the spot area, expands that area by roiInflatePercent and crops out the resulting region.
*
* @public              @memberof kForwardBlockInfo
* @param   info        Info object.
* @return              roiInflatePercent
*/
kVsFx(kSize) kP3dSpotCropBlockInfo_RoiInflatePercent(kP3dSpotCropBlockInfo info);

/**
* Sets roiInflatePercent. SpotCropBlock detects the spot area, expands that area by roiInflatePercent and crops out the resulting region.
*
* @public              @memberof kForwardBlockInfo
* @param   info        Info object.
* @param   perc        The new value for roiInflatePercent.
* @return              Operation status.
*/
kVsFx(kStatus)kP3dSpotCropBlockInfo_SetRoiSkipPercent(kP3dSpotCropBlockInfo info, k32u perc);

/**
* Returns roiInflatePercent. SpotCropBlock detects the spot area, expands that area by roiInflatePercent and crops out the resulting region.
*
* @public              @memberof kForwardBlockInfo
* @param   info        Info object.
* @return              roiInflatePercent.
*/
kVsFx(kSize) kP3dSpotCropBlockInfo_RoiSkipPercent(kP3dSpotCropBlockInfo info);

/**
* Sets SearchGridSize. When looking for the spot blob in the binarized image, pixels can be skipped to 
*
* @public              @memberof kForwardBlockInfo
* @param   info        Info object.
* @param   perc        The new value for roiInflatePercent.
* @return              Operation status.
*/
kVsFx(kStatus)kP3dSpotCropBlockInfo_SetSearchGridSize(kP3dSpotCropBlockInfo info, k32u size);

/**
* Returns SearchGridSize. When looking for the spot blob in the binarized image, pixels can be skipped to
*
* @public              @memberof kForwardBlockInfo
* @param   info        Info object.
* @return              SearchGridSize
*/
kVsFx(kSize) kP3dSpotCropBlockInfo_SearchGridSize(kP3dSpotCropBlockInfo info);

#include <kVision/P3d/kP3dSpotCropBlockInfo.x.h>

#endif  /* kVS_SPOT_CROP_BLOCK_INFO_H */
