/** 
 * @file    kP3dSpotCropBlock.x.h
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kVS_SPOT_CROP_BLOCK_X_H
#define kVS_SPOT_CROP_BLOCK_X_H

#include <kFireSync/Data/kMsg.h>
#include <kApi/Data/kImage.h>
#include <kApi/Data/kBox.h>
#include <kFireSync/Pipe/kPxBlock.h>
#include <kVision/P3d/kP3dSpotCropBlockInfo.h>
#include <kApi/Data/kMath.h>

#define kVS_SPOT_CROP_BLOCK_DESCRIPTION "Finds the largest blob in the image, returns the region rect and crops the subsequent images to that region"

kDeclareEnumEx(kVs, kP3dSpotCropBlockPort, kValue)

typedef struct kP3dSpotCropBlockClass
{
    kPxBlockClass base;
    kAlloc alloc;
    kP3dSpotCropBlockInfo settings;
    k32u minRunLength;
    k32u spotThreshold;
    k32u roiInflatePercent;
    k32u roiSkipPercent;
    k32u searchGridSize;

    kRect32s roi;

    kPort inImage;
    kPort outCroppedImage;

    kSize imageWidth;
    kSize imageHeight;
    k32s  skipSequenceCount;
    kBool outputCurrentSequence;
    
} kP3dSpotCropBlockClass;

kDeclareClassEx(kVs, kP3dSpotCropBlock, kPxBlock)

kVsFx(const kChar*) kP3dSpotCropBlock_VDescription();
kVsFx(kStatus) kP3dSpotCropBlock_VOnSetup(kP3dSpotCropBlock block);
kVsFx(kStatus) kP3dSpotCropBlock_VOnStart(kP3dSpotCropBlock block);
kVsFx(kStatus) kP3dSpotCropBlock_VOnStop(kP3dSpotCropBlock block);
kVsFx(kStatus) kP3dSpotCropBlock_VOnReceive(kP3dSpotCropBlock block, kPxPort port, kMsgSet msg);

//non-exported (private) methods
kStatus kP3dSpotCropBlock_Init(kP3dSpotCropBlock block, kAlloc allocator);

//TODO: add any private methods here
kStatus kP3dSpotCropBlock_CropImage(kP3dSpotCropBlock block, kImage imgSrc, kRect32s roi, kImage* croppedImage);
kStatus kP3dSpotCropBlock_UpdateRoi(kP3dSpotCropBlock block, kImage img);
kStatus kP3dSpotCropBlock_InflateRoi(kP3dSpotCropBlock block, kImage img);

//cast macro

#endif  /* #ifndef kVS_SPOT_CROP_BLOCK_X_H */
