#ifndef LMITECH_KVISION_KP3D_LUTWRITER_H_INCLUDED
#define LMITECH_KVISION_KP3D_LUTWRITER_H_INCLUDED

#include <kFireSync/Client/kCamera.h>
#include <kVision/P3d/kP3dSensorCal.h>
#include <kVision/L3d/kL3dTransform2d.h>

typedef kPointer kP3dLutWriter;

typedef struct kP3dLutWriterParams 
{
    k64f rangeScale;
    k32u intensityMultiplier;

    k32u centreStep;

} kP3dLutWriterParams;

kVsFx(kStatus) kP3dLutWriter_Construct(kP3dLutWriter* writer, kCamera camera, const kP3dLutWriterParams* params, kP3dSensorCal cal);
kVsFx(kStatus) kP3dLutWriter_Destroy(kP3dLutWriter writer);

kVsFx(kStatus) kP3dLutWriter_Apply(kP3dLutWriter writer, const kL3dTransform2d* transform);
kVsFx(kStatus) kP3dLutWriter_ExportLut(kP3dLutWriter writer, kStorage storage);

#endif /* #ifndef LMITECH_KVISION_KP3D_LUTWRITER_H_INCLUDED */
