#ifndef LMITECH_KVISION_L3D_TRANSFORM2D_H_INCLUDED
#define LMITECH_KVISION_L3D_TRANSFORM2D_H_INCLUDED

#include <kVision/L3d/kL3dCommon.h>

/* 
    2D transformation matrix 

    [ xx xy xt ]
    [ yx yy yt ]
    [ 0  0  1  ]
*/

typedef struct kL3dTransform2d 
{
    k64f xx;
    k64f xy;
    k64f xt;
    k64f yx;
    k64f yy;
    k64f yt;
} kL3dTransform2d;

kDeclareValueEx(kVs, kL3dTransform2d, kValue)

kVsFx(kStatus) kL3dTransform2d_Write(const kL3dTransform2d* transform, kXml xml, kXmlItem item);
kVsFx(kStatus) kL3dTransform2d_Read(kL3dTransform2d* transform, kXml xml, kXmlItem item);

kVsFx(kStatus) kL3dTransform2d_Identity(kL3dTransform2d* transform);

kVsFx(kStatus) kL3dTransform2d_Translate(const kL3dTransform2d* transform, k64f xOffset, k64f yOffset, kL3dTransform2d* result);
kVsFx(kStatus) kL3dTransform2d_Rotate(const kL3dTransform2d* transform, k64f degrees, kL3dTransform2d* result);
kVsFx(kStatus) kL3dTransform2d_Scale(const kL3dTransform2d* transform, k64f xScale, k64f yScale, kL3dTransform2d* result);

kVsFx(kStatus) kL3dTransform2d_Mul(const kL3dTransform2d* right, const kL3dTransform2d* left, kL3dTransform2d* result);
kVsFx(kStatus) kL3dTransform2d_Apply(const kL3dTransform2d* transform, k64f x, k64f y, k64f* xOut, k64f* yOut);
kVsFx(kStatus) kL3dTransform2d_ApplyN(const kL3dTransform2d* transform, const k64f* x, const k64f* y, k32u count, k64f* xOut, k64f* yOut);

#endif /* #define LMITECH_KVISION_L3D_TRANSFORM2D_H_INCLUDED */
