#ifndef LMITECH_KVISION_L3D_ZSPOTSBLOCKINFO_H_INCLUDED
#define LMITECH_KVISION_L3D_ZSPOTSBLOCKINFO_H_INCLUDED 

#include <kApi/Data/kXml.h>
#include <kFireSync/Client/Camera/Algorithms/kAcgInfo.h>

typedef struct kL3dSpotsBlockInfoClass 
{
    kObjectClass base;

    k32u threshold;
    k32u widthThreshold;
    k32u minSpotWidth;
    k32u maxSpotWidth;
    k32u maxSpots;
    k32u imageWidth;
    k32u imageHeight;
    kBool columnBased;

    k32u spotAlgorithm;
    k32u sobelEdgeWindow;
    k32u sobelAverageWindow;
    k32u minSum;
    kL3dSpotType spotType;
    kAcgSpotFormat spotFormat;
    kBool entryDebounceEnabled;
    k32u exitIntensityThreshold;
} kL3dSpotsBlockInfoClass;

kDeclareClassEx(kVs, kL3dSpotsBlockInfo, kObject)

kStatus kL3dSpotsBlockInfo_Init(kL3dSpotsBlockInfo info, kType type, kAlloc allocator);
kVsFx(kStatus) kL3dSpotsBlockInfo_VRelease(kL3dSpotsBlockInfo info);

#endif /* #ifndef LMITECH_KVISION_L3D_ZSPOTSBLOCKINFO_H_INCLUDED */
