#ifndef LMITECH_KVISION_L3D_ZSENSORCAL_H_INCLUDED
#define LMITECH_KVISION_L3D_ZSENSORCAL_H_INCLUDED

#include <kVision/L3d/kL3dPolynomialCalData.h>
#include <kVision/L3d/kL3dRangeCalData.h>
#include <kVision/L3d/kL3dUtilities.h>
#include <kFireSync/Data/kDataTree.h>
#include <kApi/Utils/kUtils.h>
#include <kApi/Data/kBytes.h>
#include <kApi/Io/kDat5Serializer.h>
#include <stdio.h>
#include <string.h>

typedef struct kL3dSensorCalEntry 
{
    k32u calibrated; /* boolean is saved as k32u in version 0 */

    kArray1 centreBegin;
    kArray1 centreEnd;

    kL3dCalData data;

} kL3dSensorCalEntry;

typedef struct kL3dSensorCalClass 
{   
    kObjectClass base;
    kL3dSensorCalParams params;

    k32u id;
    kString timestamp;

    kL3dCameraWindow window;
    kArray1 entries;

} kL3dSensorCalClass;

kDeclareClassEx(kVs, kL3dSensorCal, kObject)
kDeclareValueEx(kVs, kL3dSensorCalParams, kValue)

#define kL3D_SENSOR_CAL_VERSION (1)

kStatus kL3dSensorCal_Init(kL3dSensorCal sensorCal, kType type, const kL3dSensorCalParams* params, kAlloc allocator);
kVsFx(kStatus) kL3dSensorCal_VRelease(kL3dSensorCal sensorCal);
kStatus kL3dSensorCal_Release(kL3dSensorCal sensorCal);

kStatus kL3dSensorCal_Read(kL3dSensorCal sensorCal, kDataTree tree, kDataTreeItem item);
kStatus kL3dSensorCal_Write(kL3dSensorCal sensorCal, kDataTree tree, kDataTreeItem item);

kL3dSensorCalEntry* kL3dSensorCal_EntryAt(kL3dSensorCal sensorCal, k32u lineIndex);
kStatus kL3dSensorCal_InitEntry(kL3dSensorCal sensorCal, kL3dSensorCalEntry* entry, k32u lineIndex);
kStatus kL3dSensorCal_DestroyEntry(kL3dSensorCal sensorCal, k32u lineIndex);

#endif /* #ifndef LMITECH_KVISION_L3D_ZSENSORCAL_H_INCLUDED */
