#ifndef LMITECH_KVISION_L3D_RANGEAREASAMPLER_H_INCLUDED
#define LMITECH_KVISION_L3D_RANGEAREASAMPLER_H_INCLUDED 

#include <kVision/L3d/kL3dCommon.h>

typedef kPointer kL3dRangeAreaSampler;

typedef struct kL3dRangeAreaSamplerParams 
{
    k32u lineWidth;
    k16s yStep;
    k32u maxSteps;
} kL3dRangeAreaSamplerParams;

typedef kStatus (*kL3dRangeAreaSamplerHandler)(kPointer context, kL3dRangeAreaSampler sampler, k32s position, k16s* ranges); 

kVsFx(kStatus) kL3dRangeAreaSampler_Construct(kL3dRangeAreaSampler * sampler, const kL3dRangeAreaSamplerParams* params, kL3dRangeAreaSamplerHandler handler, kPointer context);
kVsFx(kStatus) kL3dRangeAreaSampler_Destroy(kL3dRangeAreaSampler sampler);

kVsFx(k32u) kL3dRangeAreaSampler_SliceCount(kL3dRangeAreaSampler sampler);
kVsFx(k32s) kL3dRangeAreaSampler_PositionAt(kL3dRangeAreaSampler sampler, k32u sliceIndex);
kVsFx(k32s) kL3dRangeAreaSampler_IndexAt(kL3dRangeAreaSampler sampler, k32s y);

kVsFx(k16s*) kL3dRangeAreaSampler_RangesAt(kL3dRangeAreaSampler sampler, k32u index, k32u point);

kVsFx(kStatus) kL3dRangeAreaSampler_SwitchBuffer(kL3dRangeAreaSampler sampler, kArray2* currentBuffer);
kVsFx(kStatus) kL3dRangeAreaSampler_Result(kL3dRangeAreaSampler sampler, k32u start, k32u count, kArray2 result); 
kVsFx(kStatus) kL3dRangeAreaSampler_Update(kL3dRangeAreaSampler sampler, k32s yOffset, k16s* points, k32u pointCount, k32u channelCount);

#endif /* #ifndef LMITECH_KVISION_L3D_RANGEAREASAMPLER_H_INCLUDED */
