#ifndef LMITECH_KVISION_L3D_MODELLIST_H_INCLUDED
#define LMITECH_KVISION_L3D_MODELLIST_H_INCLUDED

#include <kVision/L3d/kL3dCommon.h>

typedef kPointer kL3dModelList;

kVsFx(kStatus) kL3dModelList_Construct(kL3dModelList* list);
kVsFx(kStatus) kL3dModelList_Load(kL3dModelList* list, const kChar* fileName);
kVsFx(kStatus) kL3dModelList_Destroy(kL3dModelList list);
kVsFx(kStatus) kL3dModelList_Store(kL3dModelList list, const kChar* fileName);

kVsFx(kStatus) kL3dModelList_Read(kL3dModelList list, kXml xml, kXmlItem item);
kVsFx(kStatus) kL3dModelList_Write(kL3dModelList list, kXml xml, kXmlItem item);

kVsFx(k32u) kL3dModelList_Count(kL3dModelList list);
kVsFx(const kChar*) kL3dModelList_At(kL3dModelList list, k32u index);
kVsFx(kStatus) kL3dModelList_Add(kL3dModelList list, const kChar* model);

#endif /* #ifndef LMITECH_KVISION_L3D_MODELLIST_H_INCLUDED */
