/** 
 * @file    kL3dLutActionInfo.h
 * @brief   Declares the kL3dLutActionInfo class. 
 * 
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef LMITECH_KVISION_L3D_LUT_ACTION_INFO_H_INCLUDED
#define LMITECH_KVISION_L3D_LUT_ACTION_INFO_H_INCLUDED

#include <kVision/Common/kVision.h>
#include <kApi/Data/kXml.h>
#include <kVision/L3d/kL3dTransform2d.h>

/**
 * @class   kL3dLutActionInfo
 * @ingroup kVision
 * @brief   Settings for kL3dLutAction.
 */
typedef kObject kL3dLutActionInfo; 

typedef enum
{
    kL3D_LUT_ACTION_TEST_PATTERN_REDUCE   = 0x01,
    kL3D_LUT_ACTION_TEST_PATTERN_OFFSET   = 0x02,
    kL3D_LUT_ACTION_TEST_PATTERN_DECIMATE = 0x04
} kL3dLutWriterTestPattern;

kVsFx(kStatus) kL3dLutActionInfo_Construct(kL3dLutActionInfo* info, kAlloc allocator);

kVsFx(kStatus) kL3dLutActionInfo_Load(kL3dLutActionInfo* info, kXml xml, kAlloc allocator);
kVsFx(kStatus) kL3dLutActionInfo_Store(kL3dLutActionInfo info, kXml* xml, kAlloc allocator);

kVsFx(kStatus) kL3dLutActionInfo_Write(kL3dLutActionInfo info, kXml xml, kXmlItem item);
kVsFx(kStatus) kL3dLutActionInfo_Read(kL3dLutActionInfo info, kXml xml, kXmlItem item);

kVsFx(kStatus) kL3dLutActionInfo_Clear(kL3dLutActionInfo info); 
kVsFx(kStatus) kL3dLutActionInfo_Validate(kL3dLutActionInfo info); 

kVsFx(const kChar*) kL3dLutActionInfo_CalFileName(kL3dLutActionInfo info);
kVsFx(kStatus) kL3dLutActionInfo_SetCalFileName(kL3dLutActionInfo info, const kChar* calFileName);

kVsFx(k32s) kL3dLutActionInfo_TestPattern(kL3dLutActionInfo info);
kVsFx(kStatus) kL3dLutActionInfo_SetTestPattern(kL3dLutActionInfo info, k32s pattern);

kVsFx(k32u) kL3dLutActionInfo_IntensityMultiplier(kL3dLutActionInfo info);
kVsFx(kStatus) kL3dLutActionInfo_SetIntensityMultiplier(kL3dLutActionInfo info, k32u multiplier);

kVsFx(k32u) kL3dLutActionInfo_ViewIndex(kL3dLutActionInfo info);
kVsFx(kStatus) kL3dLutActionInfo_SetViewIndex(kL3dLutActionInfo info, k32u index);

kVsFx(k64f) kL3dLutActionInfo_XResolution(kL3dLutActionInfo info);
kVsFx(kStatus) kL3dLutActionInfo_SetXResolution(kL3dLutActionInfo info, k64f resolution);

kVsFx(k64f) kL3dLutActionInfo_ZResolution(kL3dLutActionInfo info);
kVsFx(kStatus) kL3dLutActionInfo_SetZResolution(kL3dLutActionInfo info, k64f resolution);

kVsFx(const kL3dTransform2d*) kL3dLutActionInfo_Transform(kL3dLutActionInfo info);
kVsFx(kStatus) kL3dLutActionInfo_SetTransform(kL3dLutActionInfo info, const kL3dTransform2d* transform);

kVsFx(const kRect64f*) kL3dLutActionInfo_Roi(kL3dLutActionInfo info);
kVsFx(kStatus) kL3dLutActionInfo_SetRoi(kL3dLutActionInfo info, const kRect64f* roi);

kVsFx(kBool) kL3dLutActionInfo_ExportLuts(kL3dLutActionInfo info);
kVsFx(kStatus) kL3dLutActionInfo_SetExportLuts(kL3dLutActionInfo info, kBool exportLuts);

kVsFx(kBool) kL3dLutActionInfo_UseLegacy(kL3dLutActionInfo info);
kVsFx(kStatus) kL3dLutActionInfo_SetUseLegacy(kL3dLutActionInfo info, kBool useLegacy);

#include <kVision/L3d/kL3dLutActionInfo.x.h>

#endif
