/**
* @file    kG3dContourHistogram.x.h
* @brief   
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_kS3D_COUNTURHISTOGRAM_X_H
#define KVISION_kS3D_COUNTURHISTOGRAM_X_H

typedef struct kG3dContourHistogramClass
{
    kObjectClass base;
    kArray1 contourPoints;
    kArray1 cosTab;
    kArray2 histoMap;
    kArray2 countMap;
    kArrayList pointSegment;
    k32s imageSizeX;
    k32s imageSizeY;
    k32s xmin, xmax;
    k32s ymin, ymax;
    k32s histoSizeY;
    k32s histoSizeX;
    k64f scaleY;
    k32s maxValue;
    k32s threshold;
    k32s thresholdRate;
    k32s lineCount;
    kBool borderOnly;

} kG3dContourHistogramClass;

kDeclareClassEx(kVs, kG3dContourHistogram, kObject)

kStatus kG3dContourHistogram_Init(kG3dContourHistogram histogram, kType classType, kAlloc alloc);

kVsFx(kStatus) kG3dContourHistogram_VInitClone(kG3dContourHistogram histogram, kG3dContourHistogram source, kAlloc allocator);
kVsFx(kSize)   kG3dContourHistogram_VSize(kG3dContourHistogram histogram);
kVsFx(kStatus) kG3dContourHistogram_VRelease(kG3dContourHistogram histogram);

kStatus kG3dContourHistogram_Release(kG3dContourHistogram histogram);

kStatus kG3dContourHistogram_Setup(kG3dContourHistogram histogram);
kStatus kG3dContourHistogram_FillMap(kG3dContourHistogram histogram);
kStatus kG3dContourHistogram_SegmentMap(kG3dContourHistogram histogram);
kStatus kG3dContourHistogram_FillLineIndex(kG3dContourHistogram histogram);

#endif  /* KVISION_kS3D_COUNTURHISTOGRAM_X_H */
