#ifndef kVS_LOG_H_INCLUDED
#define kVS_LOG_H_INCLUDED

#include <kVision/Common/kVision.h>
#include <kApi/kApi.h>

/** 
 * Sets the handler callback for LogInfo.
 *
 * This function should be called as early as possible, and ideally not changed later. None of the set functions are threadsafe with their respective
 * log functions. If a call is being made to _LogX, and the handler is modified, behavior is undefined.
 *
 * @param   function    Callback function. Sender will be null, and args will be a kChar*.
 * @param   receiver    Receiver context pointer (can be kNULL).
 * @return              Operation status. 
 */
kVsFx(kStatus) kVsLog_SetInfoHandler(kCallbackFx function, kPointer receiver);

/** 
 * Sets the handler callback for LogWarning.
 *
 * This function should be called as early as possible, and ideally not changed later. None of the set functions are threadsafe with their respective
 * log functions. If a call is being made to _LogX, and the handler is modified, behavior is undefined.
 *
 * @param   function    Callback function. Sender will be null, and args will be a kChar*.
 * @param   receiver    Receiver context pointer (can be kNULL).
 * @return              Operation status. 
 */
kVsFx(kStatus) kVsLog_SetWarningHandler(kCallbackFx function, kPointer receiver);

/** 
 * Sets the handler callback for LogError.
 *
 * This function should be called as early as possible, and ideally not changed later. None of the set functions are threadsafe with their respective
 * log functions. If a call is being made to _LogX, and the handler is modified, behavior is undefined.
 *
 * @param   function    Callback function. Sender will be null, and args will be a kChar*.
 * @param   receiver    Receiver context pointer (can be kNULL).
 * @return              Operation status. 
 */
kVsFx(kStatus) kVsLog_SetErrorHandler(kCallbackFx function, kPointer receiver);

/** 
 * Sets the handler callback for LogDebug.
 *
 * This function should be called as early as possible, and ideally not changed later. None of the set functions are threadsafe with their respective
 * log functions. If a call is being made to _LogX, and the handler is modified, behavior is undefined.
 *
 * @param   function    Callback function. Sender will be null, and args will be a kChar*.
 * @param   receiver    Receiver context pointer (can be kNULL).
 * @return              Operation status. 
 */
kVsFx(kStatus) kVsLog_SetDebugHandler(kCallbackFx function, kPointer receiver);

/** 
 * Logs a debug message using the Debug handler. Returns kOK if no handler is set.
 *
 * @param   format      Format string.
 * @return              Operation status. 
 */
kVsFx(kStatus) kVsLog_LogDebug(const kChar* format, ...);

/** 
 * Logs an info message using the Info handler. Returns kOK if no handler is set.
 *
 * @param   format      Format string.
 * @return              Operation status. 
 */
kVsFx(kStatus) kVsLog_LogInfo(const kChar* format, ...);

/** 
 * Logs a warning message using the Warning handler. Returns kOK if no handler is set.
 *
 * @param   format      Format string.
 * @return              Operation status. 
 */
kVsFx(kStatus) kVsLog_LogWarning(const kChar* format, ...);

/** 
 * Logs an error message using the Error handler. Returns kOK if no handler is set.
 *
 * @param   format      Format string.
 * @return              Operation status. 
 */
kVsFx(kStatus) kVsLog_LogError(const kChar* format, ...);

#endif      /* #ifndef kVS_LOG_H_INCLUDED */
