/** 
 * @file    kSerialOutTestInfo.h
 * @brief   Declares the kSerialOutTestInfo class. 
 * 
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef LMITECH_KVISION_KSERIALOUT_TEST_INFO_H
#define LMITECH_KVISION_KSERIALOUT_TEST_INFO_H

#include <kVision/Common/kVision.h>
#include <kApi/Data/kXml.h>
#include <kFireSync/Client/kSerialOut.h>

#define kSERIAL_OUT_TEST_MIN_SELCOM_DATA        (0x0000)
#define kSERIAL_OUT_TEST_MAX_SELCOM_DATA        (0xFFFF)

#define kSERIAL_OUT_TEST_MIN_UART_DATA          (0x20)
#define kSERIAL_OUT_TEST_MAX_UART_DATA          (0x7E)

typedef kObject kSerialOutTestInfo; 

kVsFx(kStatus) kSerialOutTestInfo_Construct(kSerialOutTestInfo* info, kAlloc allocator);

kVsFx(kStatus) kSerialOutTestInfo_Load(kSerialOutTestInfo* info, kXml xml, kAlloc allocator);
kVsFx(kStatus) kSerialOutTestInfo_Store(kSerialOutTestInfo info, kXml* xml, kAlloc allocator);

kVsFx(kStatus) kSerialOutTestInfo_Write(kSerialOutTestInfo info, kXml xml, kXmlItem item);
kVsFx(kStatus) kSerialOutTestInfo_Read(kSerialOutTestInfo info, kXml xml, kXmlItem item);

kVsFx(kStatus) kSerialOutTestInfo_Clear(kSerialOutTestInfo info); 
kVsFx(kStatus) kSerialOutTestInfo_Validate(kSerialOutTestInfo info); 

kVsFx(kSize) kSerialOutTestInfo_SerialOutIndex(kSerialOutTestInfo info);
kVsFx(kStatus) kSerialOutTestInfo_SetSerialOutIndex(kSerialOutTestInfo info, kSize index);

kVsFx(kSerialOutMode) kSerialOutTestInfo_Mode(kSerialOutTestInfo info);
kVsFx(kStatus) kSerialOutTestInfo_SetMode(kSerialOutTestInfo info, kSerialOutMode mode);

kVsFx(k64u) kSerialOutTestInfo_Delay(kSerialOutTestInfo info);
kVsFx(kStatus) kSerialOutTestInfo_SetDelay(kSerialOutTestInfo info, k64u delay);

kVsFx(k64u) kSerialOutTestInfo_Period(kSerialOutTestInfo info);
kVsFx(kStatus) kSerialOutTestInfo_SetPeriod(kSerialOutTestInfo info, k64u period);

#include <kVision/Common/kSerialOutTestInfo.x.h>

#endif
