#ifndef LMITECH_KVISION_KIMAGEOPS_H_INCLUDED
#define LMITECH_KVISION_KIMAGEOPS_H_INCLUDED

#include <kVision/Common/kVision.h>
#include <kApi/Data/kImage.h>


///@brief Flip the contents of src (kImage<k8u>) in X (left-to-right) and place
///the result in dst (must be pre-instantiated kImage<k8u) of the same size)
kVsFx(kStatus) kImage_FlipX8u(kImage src, kImage dst);

///@brief Flip the contents of src (kImage<k8u>) in X (left-to-right) and place
///the result in dst (must be pre-instantiated kImage<k8u) of the same size). This method
/// uses kParallel to execute on multiple threads
kVsFx(kStatus) kImage_FlipX8uParallel(kImage src, kImage dst);

#include <kVision/Common/kImageOps.x.h>

#endif /*ifndef LMITECH_KVISION_KIMAGEOPS_H_INCLUDED */
