/** 
 * @file    kProtocolDef.h
 * @brief   Common FireSync protocol definitions.
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PROTOCOL_DEF_H
#define K_FIRESYNC_PROTOCOL_DEF_H

#include <kFireSync/kNodeDef.h>

/*
 *  Note to implementers: These constants represent the top-level FireSync 6+ protocol version.  Modification to the 
 *  Major or Minor components requires prior design approval. If the protocol version must be modified, please describe 
 *  the reason for the modification in the "FireSync 6+ Protocol Versions" section of the FireSync Net Protocols design document.
 */
#define kFIRESYNC_PROTOCOL_VERSION_MAJOR        (6)           ///< Always 6. 
#define kFIRESYNC_PROTOCOL_VERSION_MINOR        (3)           ///< Updated when breaking changes occur.
#define kFIRESYNC_PROTOCOL_VERSION_RELEASE      (9)           ///< Updated if non-breaking changes need to be detected through the protocol version (e.g. new commands). 

/* 
 * FDP-6 
 */

#define kFDP6_DEFAULT_PORT              (2016)
#define kFDP6_DEFAULT_VIRTUAL_PORT      (2020)

#define kFDP6_COMMAND_UPDATE                k64U(0xA08D2310D83C11E2)
#define kFDP6_COMMAND_SET_ADDRESS           k64U(0xB29C04156188709B)
#define kFDP6_COMMAND_FORCE_RESCUE          k64U(0xC266C1A704D74699)

/* 
 * FCP-6 
 */

#define kFCP6_DEFAULT_PORT      (2017)

#define kFCP6_COMMAND_INFORM_VERSION                    (0x0001) 

#define kFCP6_COMMAND_WRITE_FIRMWARE                    (0x0100) 
#define kFCP6_COMMAND_WRITE_FIRMWARE_EX                 (0x0101) 
#define kFCP6_COMMAND_CLEAR_FIRMWARE                    (0x0102) 
#define kFCP6_COMMAND_RELOAD_FIRMWARE                   (0x0103) 
#define kFCP6_COMMAND_RESET                             (0x0110)

#define kFCP6_COMMAND_WRITE_FILE                        (0x0200) 
#define kFCP6_COMMAND_COPY_FILE                         (0x0201) 
#define kFCP6_COMMAND_READ_FILE                         (0x0202) 
#define kFCP6_COMMAND_DELETE_FILE                       (0x0203) 
#define kFCP6_COMMAND_GET_FILE_INFO                     (0x0204) 
#define kFCP6_COMMAND_WRITE_FILE_EX                     (0x0205) 
#define kFCP6_COMMAND_COPY_FILE_EX                      (0x0206) 
#define kFCP6_COMMAND_CREATE_DIRECTORY                  (0x0210) 
#define kFCP6_COMMAND_DELETE_DIRECTORY                  (0x0211) 
#define kFCP6_COMMAND_LIST_DIRECTORY_ENTRIES            (0x0212) 
#define kFCP6_COMMAND_LIST_DIRECTORY_ENTRIES_EX         (0x0213) 

#define kFCP6_COMMAND_SET_DEVICE_CONFIG                 (0x0300) 
#define kFCP6_COMMAND_GET_DEVICE_CONFIG                 (0x0301) 
#define kFCP6_COMMAND_COMMIT_DEVICE_CONFIG              (0x0302) 

#define kFCP6_COMMAND_SET_MODE_CONFIG                   (0x0310) 
#define kFCP6_COMMAND_GET_MODE_CONFIG                   (0x0311) 
#define kFCP6_COMMAND_LOAD_MODE_CONFIG                  (0x0312) 
#define kFCP6_COMMAND_SAVE_MODE_CONFIG                  (0x0313) 
#define kFCP6_COMMAND_COMMIT_MODE_CONFIG                (0x0314) 

#define kFCP6_COMMAND_VALIDATE_BLOCK_CONFIG             (0x0320) 

#define kFCP6_COMMAND_CAMERA_OVERRIDE                   (0x0330) 
#define kFCP6_COMMAND_LIGHT_OVERRIDE                    (0x0331)

#define kFCP6_COMMAND_SET_DATE_TIME                     (0x0340)

#define kFCP6_COMMAND_INCREMENT_INPUT_COUNTER           (0x0350)

#define kFCP6_COMMAND_LIST_PROCEDURES                   (0x0400) 
#define kFCP6_COMMAND_INVOKE_PROCEDURE                  (0x0401)

#define kFCP6_COMMAND_LIST_VARIABLES                    (0x0410) 
#define kFCP6_COMMAND_GET_VARIABLE                      (0x0411) 
#define kFCP6_COMMAND_GET_VARIABLE_INFO                 (0x0412) 
#define kFCP6_COMMAND_SET_VARIABLE                      (0x0413) 
#define kFCP6_COMMAND_DELETE_VARIABLE                   (0x0414) 

#define kFCP6_COMMAND_VALIDATE_ACTION_CONFIG            (0x0420)
#define kFCP6_COMMAND_INVOKE_ACTION                     (0x0421)
#define kFCP6_COMMAND_INVOKE_NAMED_ACTION               (0x0422)

#define kFCP6_COMMAND_START                             (0x0500) 
#define kFCP6_COMMAND_STOP                              (0x0501) 
#define kFCP6_COMMAND_ENGAGE                            (0x0504) 

#define kFCP6_COMMAND_START_REPLAY                      (0x0510) 
#define kFCP6_COMMAND_REPLAY                            (0x0511) 

#define kFCP6_COMMAND_SCHEDULE_EVENT                    (0x0600) 
#define kFCP6_COMMAND_TRIGGER_EVENT                     (0x0601) 

#define kFCP6_COMMAND_SET_LIGHT_STATE                   (0x0610) 
#define kFCP6_COMMAND_TRIGGER_LIGHT                     (0x0611)

#define kFCP6_COMMAND_SET_DIGITAL_OUTPUT                (0x0620) 
#define kFCP6_COMMAND_TRIGGER_DIGITAL_OUTPUT            (0x0621)

#define kFCP6_COMMAND_ENQUEUE_ANALOG_OUTPUT             (0x0630) //deprecated in FS 6.1.29.x
#define kFCP6_COMMAND_ENQUEUE_ANALOG_OUTPUT_CURRENT     (0x0631)
#define kFCP6_COMMAND_WRITE_ANALOG_OUTPUT_CALIBRATION   (0x0632)

#define kFCP6_COMMAND_WRITE_RAM_IMAGE                   (0x0640)
#define kFCP6_COMMAND_WRITE_PRNU                        (0x0641)
#define kFCP6_COMMAND_WRITE_FPN                         (0x0642)
#define kFCP6_COMMAND_WRITE_RANGE_LUT                   (0x0643)
#define kFCP6_COMMAND_TRIGGER_CAMERA                    (0x0644) 
#define kFCP6_COMMAND_WRITE_PHASE_DECODER_LUT           (0x0645)
#define kFCP6_COMMAND_SET_CAMERA_CALIBRATION            (0x0646) // deprecated in FS 6.2.2.49
#define kFCP6_COMMAND_GET_CAMERA_CALIBRATION            (0x0647) // deprecated in FS 6.2.2.49
#define kFCP6_COMMAND_SET_CAMERA_LVDS_POWER             (0x0648)
#define kFCP6_COMMAND_GET_CAMERA_LVDS_POWER             (0x0649)
#define kFCP6_COMMAND_WRITE_ACCELERATION_TEST_DATA      (0x064A)
#define kFCP6_COMMAND_READ_ACCELERATION_TEST_RESULT     (0x064B)

#define kFCP6_COMMAND_LOAD_PROJECTOR_PATTERNS           (0x0650)
#define kFCP6_COMMAND_LOAD_PROJECTOR_ROW_GAINS          (0x0651)
#define kFCP6_COMMAND_LOAD_PROJECTOR_COL_GAINS          (0x0652)

#define kFCP6_COMMAND_RESET_ENCODER                     (0x0660)

#define kFCP6_COMMAND_ENABLE_LED                        (0x0670)
#define kFCP6_COMMAND_SET_LED_MODE                      (0x0671)

#define kFCP6_COMMAND_SET_GPIO_DIRECTION                (0x0675) // removed in FS 6.1.13.40
#define kFCP6_COMMAND_GET_GPIO_DIRECTION                (0x0676) // removed in FS 6.1.13.40
#define kFCP6_COMMAND_SET_GPIO_STATE                    (0x0677)
#define kFCP6_COMMAND_GET_GPIO_STATE                    (0x0678)

#define kFCP6_COMMAND_WRITE_SERIAL_OUTPUT               (0x0680)

#define kFCP6_COMMAND_LOCK_OUT_LIGHT                        (0x0690)
#define kFCP6_COMMAND_SET_LIGHT_DRIVER_MODEL                (0x0691)
#define kFCP6_COMMAND_GET_LIGHT_DRIVER_MODEL                (0x0692)
#define kFCP6_COMMAND_SET_LIGHT_DRIVER_POWER                (0x0693)
#define kFCP6_COMMAND_GET_LIGHT_DRIVER_POWER                (0x0694)
#define kFCP6_COMMAND_SET_LIGHT_DRIVER_CURRENT_LIMIT        (0x0695)
#define kFCP6_COMMAND_GET_LIGHT_DRIVER_CURRENT_LIMIT        (0x0696)
#define kFCP6_COMMAND_GET_LIGHT_DRIVER_REMAINING_SLOT_COUNT (0x0697)
#define kFCP6_COMMAND_SET_LIGHT_DRIVER_CALIBRATION          (0x0698)
#define kFCP6_COMMAND_GET_LIGHT_DRIVER_CALIBRATION          (0x0699)
#define kFCP6_COMMAND_ENABLE_LIGHT_DRIVER_COMPENSATION      (0x069A)
#define kFCP6_COMMAND_SET_LIGHT_DRIVER_CONTROL              (0x069B)
#define kFCP6_COMMAND_GET_LIGHT_DRIVER_CONTROL              (0x069C)
#define kFCP6_COMMAND_READ_LIGHT_DRIVER_TEMPERATURE         (0x069D)

#define kFCP6_COMMAND_GET_INFO                          (0x0700) 
#define kFCP6_COMMAND_GET_STATE                         (0x0701) 
#define kFCP6_COMMAND_GET_HEALTH                        (0x0702) 
#define kFCP6_COMMAND_READ_HEALTH_LOG                   (0x0703)
#define kFCP6_COMMAND_CLEAR_HEALTH_LOG                  (0x0704)
#define kFCP6_COMMAND_GET_NODE_STATS                    (0x0710) 
#define kFCP6_COMMAND_GET_EVENT_STATS                   (0x0711) 
#define kFCP6_COMMAND_GET_CAMERA_STATS                  (0x0712) 
#define kFCP6_COMMAND_GET_LIGHT_STATS                   (0x0713) 
#define kFCP6_COMMAND_GET_PROJECTOR_STATS               (0x0714) 
#define kFCP6_COMMAND_GET_ANALOG_STATS                  (0x0715) 
#define kFCP6_COMMAND_GET_DIGITAL_STATS                 (0x0716) 
#define kFCP6_COMMAND_GET_SERIAL_STATS                  (0x0717) 

#define kFCP6_COMMAND_READ_REGISTERS                    (0x0803)
#define kFCP6_COMMAND_READ_REGISTER_OVERRIDES           (0x0804)
#define kFCP6_COMMAND_WRITE_REGISTER_OVERRIDES          (0x0805)

#define kFCP6_COMMAND_READ_LOG_HISTORY                  (0x0810)
#define kFCP6_COMMAND_READ_CRASH_LOG                    (0x0811)
#define kFCP6_COMMAND_CLEAR_CRASH_LOG                   (0x0812)

#define kFCP6_COMMAND_I2C_READ                          (0x0820)
#define kFCP6_COMMAND_I2C_WRITE                         (0x0821)

#define kFCP6_COMMAND_READ_MEMORY                       (0x0830)
#define kFCP6_COMMAND_WRITE_MEMORY                      (0x0831)

#define kFCP6_COMMAND_BEGIN_SPI                         (0x0840)
#define kFCP6_COMMAND_END_SPI                           (0x0841)
#define kFCP6_COMMAND_SPI_READ                          (0x0842)
#define kFCP6_COMMAND_SPI_WRITE                         (0x0843)

#define kFCP6_COMMAND_RESET_IO_TEST                     (0x0900)
#define kFCP6_COMMAND_GET_IO_TEST_STATS                 (0x0901)
#define kFCP6_COMMAND_READ_IO_TEST_SERIAL_DATA          (0x0902)

#define kFCP6_COMMAND_TEST_JIG_COMMAND                  (0x0910)
#define kFCP6_COMMAND_GET_TEST_JIG_STATS                (0x0911)

#define kFCP6_COMMAND_GET_ORIENTATION_STATS             (0x0A00)
#define kFCP6_COMMAND_START_ORIENTATION_CALIBRATION     (0x0A01)

 /* 
  * FHSP-6 
  */

#define kFHSP6_DEFAULT_PORT                     (2018)

#define kFHSP6_COMMAND_CONFIGURE_CHANNEL        (0x100)

#define kFHSP6_CONTROL_BEGIN_HEALTHMSG          (0x110)
#define kFHSP6_CONTROL_BEGIN_PROFILEMSG         (0x120)
#define kFHSP6_CONTROL_BEGIN_OBJ                (0x130)

#define kFHSP6_CONTROL_ADD_INDICATOR             (0x10)
#define kFHSP6_CONTROL_REMOVE_INDICATOR          (0x20)
#define kFHSP6_CONTROL_UPDATE_PROFILE            (0x30)
#define kFHSP6_CONTROL_UPDATE_HEALTH_8S          (0x40)
#define kFHSP6_CONTROL_UPDATE_HEALTH_16S         (0x41)
#define kFHSP6_CONTROL_UPDATE_HEALTH_32S         (0x42)
#define kFHSP6_CONTROL_UPDATE_HEALTH_64S         (0x43)
#define kFHSP6_CONTROL_END_MESSAGE               (0x80)

 /* 
  * FDSP-6 
  */

#define kFDSP6_DEFAULT_PORT         (2019)


#define kFDSP6_COMMAND_CONFIGURE_CHANNEL            (0x2000) 

#define kFSDP6_CONTROL_END_OF_SESSION               (0)
#define kFSDP6_CONTROL_CONFIGURATION_REPLY          (1)

#endif
