/** 
 * @file    kUpgEvaluator.h
 * @brief   Declares the kUpgEvaluator class. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kFS_UPG_EVALUATOR_H
#define kFS_UPG_EVALUATOR_H

#include <kFireSync/kFsDef.h>
#include <kFireSync/Data/kPropertyList.h>
#include <kFireSync/Upgrade/kUpgCondition.h>

/**
 * Evaluates a kUpgCondition.
 *
 * @class       kUpgEvaluator
 * @extends     kObject
 * @ingroup     kFireSync-Upgrade
 */
typedef kObject kUpgEvaluator;

/** @cond */
kDeclareClassEx(kFs, kUpgEvaluator, kObject)
/** @endcond */

kFsFx(kStatus) kUpgEvaluator_Construct(kUpgEvaluator* evaluator, kPropertyList propertyList, kAlloc alloc);

kFsFx(kStatus) kUpgEvaluator_SetMacro(kUpgEvaluator evaluator, const kChar* name, kBool value);

kFsFx(kStatus) kUpgEvaluator_Evaluate(kUpgEvaluator evaluator, kUpgCondition condition, kBool* result);

// TODO: improve this with a "blame" list
kFsFx(const kChar*) kUpgEvaluator_LastProperty(kUpgEvaluator evaluator);

#endif
