/** 
 * @file    kUpgCondition.h
 * @brief   Declares the kUpgCondition class. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kFS_UPG_CONDITION_H
#define kFS_UPG_CONDITION_H

#include <kFireSync/kFsDef.h>

/**
 * Represents a boolean condition in validation and script files.
 *
 * @class       kUpgCondition
 * @extends     kObject
 * @ingroup     kFireSync-Upgrade
 */
typedef kObject kUpgCondition;

/** @cond */
kDeclareClassEx(kFs, kUpgCondition, kObject)
/** @endcond */

typedef enum
{
    kFS_UPG_CONDITION_OP_IS_NULL,
    kFS_UPG_CONDITION_OP_EQ,
    kFS_UPG_CONDITION_OP_LT,
    kFS_UPG_CONDITION_OP_GT,
    kFS_UPG_CONDITION_OP_NOT,
    kFS_UPG_CONDITION_OP_AND,
    kFS_UPG_CONDITION_OP_OR,
    kFS_UPG_CONDITION_OP_MACRO
} kUpgConditionOp;

typedef enum
{
    kFS_UPG_CONDITION_VALUE_STRING,
    kFS_UPG_CONDITION_VALUE_INT,
    kFS_UPG_CONDITION_VALUE_FLOAT,
    kFS_UPG_CONDITION_VALUE_VERSION
} kUpgConditionValueType;

kFsFx(kStatus) kUpgCondition_Construct(kUpgCondition* condition, kAlloc alloc);

kFsFx(kStatus) kUpgCondition_Read(kUpgCondition condition, kXml xml, kXmlItem item);
kFsFx(kStatus) kUpgCondition_Write(kUpgCondition condition, kXml xml, kXmlItem item);

kFsFx(kStatus) kUpgCondition_SetOp(kUpgCondition condition, kUpgConditionOp test);
kFsFx(kUpgConditionOp) kUpgCondition_Op(kUpgCondition condition);

kFsFx(kStatus) kUpgCondition_SetName(kUpgCondition condition, const kChar* name);
kFsFx(const kChar*) kUpgCondition_Name(kUpgCondition condition);

kFsFx(kStatus) kUpgCondition_SetProperty(kUpgCondition condition, const kChar* property);
kFsFx(const kChar*) kUpgCondition_Property(kUpgCondition condition);

kFsFx(kStatus) kUpgCondition_SetValueType(kUpgCondition condition, kUpgConditionValueType type);
kFsFx(kUpgConditionValueType) kUpgCondition_ValueType(kUpgCondition condition);

kFsFx(kStatus) kUpgCondition_SetValue(kUpgCondition condition, const kChar* value);
kFsFx(const kChar*) kUpgCondition_Value(kUpgCondition condition);

kFsFx(kStatus) kUpgCondition_AddRule(kUpgCondition condition, kUpgCondition* child);
kFsFx(kStatus) kUpgCondition_DeleteRule(kUpgCondition condition, kSize index);
kFsFx(kSize) kUpgCondition_RuleCount(kUpgCondition condition);
kFsFx(kUpgCondition) kUpgCondition_RuleAt(kUpgCondition condition, kSize index);

#endif
