/** 
 * @file    kSvDef.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_DEF_H
#define K_FIRESYC_SERVER_DEF_H

#include <kFireSync/kNodeDef.h>

/**
 * @struct  kSvNodeService
 * @extends kValue
 * @ingroup kFireSync-Server  
 * @brief   Service type enumeration.
 */
typedef k32s kSvNodeService; 

/** @relates kSvNodeService @{ */
#define kSV_NODE_SERVICE_NULL               (0x00)      ///< No services. 
#define kSV_NODE_SERVICE_DISCOVERY          (0x01)      ///< Network discovery output service. 
#define kSV_NODE_SERVICE_CONTROL            (0x02)      ///< Control service. 
#define kSV_NODE_SERVICE_DATA               (0x04)      ///< Data output service.
#define kSV_NODE_SERVICE_HEALTH             (0x08)      ///< Health output service. 
#define kSV_NODE_SERVICE_WEB                (0x10)      ///< Web service. 
#define kSV_NODE_SERVICE_ALL                (0xFF)      ///< All services. 
/** @} */


/**
 * @struct  kSvWatchdogArgs
 * @extends kValue
 * @ingroup kFireSync-Server
 * @brief   Argument passed to a kSvWatchdogFx callback.
 * @see     kSvWatchdogFx
*/
typedef struct kSvWatchdogArgs
{
    kRestartReason reason;          ///< Reason for device restart (or kRESTART_REASON_NONE to avoid reset). 
} kSvWatchdogArgs;

/**
 * Signature for a kSvNode watchdog callback function.
 *
 * The final argument to this callback is a pointer to a kSvWatchdogArgs structure. The 'reason' 
 * field of this structure should be used by the callback to determine the behaviour of the watchdog. 
 * By default, this field is set to kRESTART_REASON_NONE (do not reset).  If a reset is determined to 
 * be necessary, set this field to any other value.  If supported by the underlying hardware, the reason 
 * code will be preserved and available for inspection after reboot (via kNode_Info, or the Node/ResetReason 
 * indicator).  
 * 
 * The operation status returned by this function is ignored.
 *
 * @param   receiver   Receiver context pointer.
 * @param   node       Server node object (kSvNode)
 * @param   args       Pointer to callback argument.
 * @return             Ignored.
 * @see                kSvNode_EnableWatchdog
 */
typedef kStatus(kCall* kSvWatchdogFx)(kPointer receiver, kObject serverNode, kSvWatchdogArgs* args);

#include <kFireSync/Server/kSvDef.x.h>

#endif
