/** 
 * @file    kSvWeb.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_WEB_X_H
#define K_FIRESYC_SERVER_WEB_X_H

typedef struct kSvWebClass
{
    kObjectClass base; 
    kSvNode node;                       //Parent/owner.

    kHttpServer server;                 //kHttpServer object. 

    kCallback handler;                  //Request handler. 
    kLock handlerLock;                  //Provides exclusive access to handler. 

} kSvWebClass; 

kDeclareClassEx(kFs, kSvWeb, kObject)
        
kFsFx(kStatus) kSvWeb_Init(kSvWeb web, kType type, kSvNode node, kAlloc alloc);
kFsFx(kStatus) kSvWeb_VRelease(kSvWeb web);

kFsFx(kSvNode) kSvWeb_Node(kSvWeb web); 

kFsFx(kStatus) kSvWeb_OnRequest(kSvWeb web, kHttpServer server, kHttpServerChannel channel);
kFsFx(kStatus) kSvWeb_DefaultRequstHandler(kSvWeb web, kHttpServer server, kHttpServerChannel channel);

kFsFx(kStatus) kSvWeb_OnIndexPage(kSvWeb web, kHttpServer server, kHttpServerChannel channel); 
kFsFx(kStatus) kSvWeb_OnNotFound(kSvWeb web, kHttpServer server, kHttpServerChannel channel); 
kFsFx(kStatus) kSvWeb_OnNotImplemented(kSvWeb web, kHttpServer server, kHttpServerChannel channel); 

#endif
