/** 
 * @file    kSvHealthOutChannel.h
 * @brief   Declares the kSvHealthOutChannel class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_HEALTH_OUT_CHANNEL_H
#define K_FIRESYC_SERVER_HEALTH_OUT_CHANNEL_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class   kSvHealthOutChannel
 * @extends kObject
 * @ingroup kFireSync-Server-Network
 * @brief   Abstract base class representing the server side of a health connection.
 */
//typedef kObject kSvHealthOutChannel;      --forward-declared in kFsDef.x.h

kFsFx(kStatus) kSvHealthOutChannel_Send(kSvHealthOutChannel channel, kObject info);

kFsFx(kBool) kSvHealthOutChannel_IsActive(kSvHealthOutChannel channel);

#include <kFireSync/Server/Network/kSvHealthOutChannel.x.h>

#endif
