/** 
 * @file    kSvHealthOut.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_HEALTH_OUT_X_H
#define K_FIRESYC_SERVER_HEALTH_OUT_X_H

#define kSV_HEALTH_OUT_MAX_CONNECTIONS             (8)             ///< Maximum simultaneous connnections (includes app channels; at most one).

#define kSV_HEALTH_OUT_QUIT_QUERY_PERIOD           (100000)        ///< Polling interval for quit (stop) status (us). 

#define kSV_HEALTH_OUT_DISPATCH_PERIOD             (200000)        ///< Health message dispatch period (us). 

#define kSV_HEALTH_OUT_LOG_FIRST_SNAPSHOT_PERIOD   (300000)        ///< Time to generation of first log snapshot after starting the health service (us). 

#define kSV_HEALTH_OUT_CLIENT_READ_BUFFER          (-1) 
#define kSV_HEALTH_OUT_SOCKET_READ_BUFFER          (-1) 
#define kSV_HEALTH_OUT_SOCKET_WRITE_BUFFER         (16384) 

typedef struct kSvHealthOutClass
{
    kObjectClass base; 
    kSvNode node;                       //Parent/owner.
    kIpEndPoint localEndPoint;          //Local server IP endpoint.

    kThread serverThread;               //Thread for accepting new connections.
    kTcpServer server;                  //TCP server to accept new connections.

    kList connections;                  //List of connections -- kList<kSvHealthOutChannel>.
    kList connectionLock; 

    kPeriodic dispatchTimer;            //Periodic callback for generating new health messages. 
    
    kPeriodic logTimer;                 //Periodic callback for generating new health log snapshots. 
    k64u logPeriod;                     //Health logging period (if 0, uses hardware default).
    kLock logPeriodLock;                //Protects data involved in changing the logging period (timer, period).
    kBool hasReportedLogError;          //Has a health logging error already been reported?
    kHealthProbe snapshotIndexProbe;    //Health probe that records the snapshot index.

    kAtomic32s shouldQuit;              //Is the server stopping?

    kHealth provider;                   //Node health provider.
    kHealthLog log;                     //Health log, if installed.

} kSvHealthOutClass; 

kDeclareClassEx(kFs, kSvHealthOut, kObject)
        
kFsFx(kStatus) kSvHealthOut_Init(kSvHealthOut service, kType type, kSvNode node, kAlloc alloc);
kFsFx(kStatus) kSvHealthOut_VRelease(kSvHealthOut service);

kFsFx(kStatus) kSvHealthOut_Parse(kSvHealthOut service, kXml xml, kXmlItem item); 
kFsFx(kStatus) kSvHealthOut_Format(kSvHealthOut service, kXml xml, kXmlItem item); 

kFsFx(kSvNode) kSvHealthOut_Node(kSvHealthOut service); 

kFsFx(kStatus) kSvHealthOut_ServerThreadEntry(kSvHealthOut service); 

kFsFx(kStatus) kSvHealthOut_AddNetChannel(kSvHealthOut service, kTcpClient client);
kFsFx(kStatus) kSvHealthOut_RemoveFirstNetChannel(kSvHealthOut service); 
kFsFx(kStatus) kSvHealthOut_RemoveInactiveChannels(kSvHealthOut service); 

kFsFx(kStatus) kSvHealthOut_OnEvent(kSvHealthOut service, kPointer sender, kArrayList events);
kFsFx(kStatus) kSvHealthOut_OnDispatchTimer(kSvHealthOut service, kPeriodic timer); 
kFsFx(kStatus) kSvHealthOut_OnFirstLogTimer(kSvHealthOut service, kPeriodic timer); 
kFsFx(kStatus) kSvHealthOut_OnLogTimer(kSvHealthOut service, kPeriodic timer);

kFsFx(kStatus) kSvHealthOut_GenerateNetworkMessages(kSvHealthOut service); 
kFsFx(kStatus) kSvHealthOut_GenerateLogSnapshot(kSvHealthOut service);

kFsFx(kStatus) kSvHealthOut_Send(kSvHealthOut service, kObject info); 

#endif

