/** 
 * @file    kSvDiscoveryProvider.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_DISCOVERY_PROVIDER_X_H
#define K_FIRESYC_SERVER_DISCOVERY_PROVIDER_X_H

#include <kFireSync/Client/Network/kDiscoveryProvider.h>

#define kSV_DISCOVERY_PROVIDER_ENUM_PERIOD            (1000000)

typedef struct kSvDiscoveryProviderClass
{
    kObjectClass base; 

    kSystem system;                 //Parent

    kPeriodic enumTimer;            //Background timer to update discovery information.
    kDiscoveryEnumFx enumFx;        //Enumeration callback. 
    kPointer enumRx;                //Enumeration receiver. 
 
    kArrayList nodes;               //Local nodes that have been started -- kArrayList<kSvNode>. 
    kArrayList discoveryInfo;       //Node discovery information -- kArrayList<kDiscoveryInfo>. 
} kSvDiscoveryProviderClass; 

kDeclareClassEx(kFs, kSvDiscoveryProvider, kObject)
        
kFsFx(kStatus) kSvDiscoveryProvider_Init(kSvDiscoveryProvider provider, kType type, kSvNode node, kAlloc alloc); 
kFsFx(kStatus) kSvDiscoveryProvider_VRelease(kSvDiscoveryProvider provider); 

kFsFx(kStatus) kSvDiscoveryProvider_FindNode(kSvDiscoveryProvider provider, k32u nodeId, kSvNode* node); 

kFsFx(kBool) kSvDiscoveryProvider_CanSetAddress(kSvDiscoveryProvider provider); 
kFsFx(kStatus) kSvDiscoveryProvider_SetAddress(kSvDiscoveryProvider provider, k32u id, kSize localAdapterId, kSize nodeInterfaceIndex, const kIpConfig* ipConfig);

kFsFx(kStatus) kSvDiscoveryProvider_SetEnumHandler(kSvDiscoveryProvider provider, kDiscoveryEnumFx function, kPointer receiver); 

kFsFx(kStatus) kSvDiscoveryProvider_Enumerate(kSvDiscoveryProvider discovery); 

kFsFx(kStatus) kSvDiscoveryProvider_StartEnum(kSvDiscoveryProvider provider); 
kFsFx(kStatus) kSvDiscoveryProvider_StopEnum(kSvDiscoveryProvider provider); 
kFsFx(kBool) kSvDiscoveryProvider_IsRunning(kSvDiscoveryProvider provider); 

kFsFx(kStatus) kSvDiscoveryProvider_OnEnumTimer(kSvDiscoveryProvider provider, kPeriodic timer); 

kFsFx(kStatus) kSvDiscoveryProvider_ConstructNodeProvider(kSvDiscoveryProvider provider, const kDiscoveryInfo* info, kNodeProvider* nodeProvider, kAlloc allocator); 

#endif
