/** 
 * @file    kSvDataIn.h
 * @brief   Declares the kSvDataIn class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_DATA_IN_H
#define K_FIRESYC_SERVER_DATA_IN_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class   kSvDataInStats
 * @extends kValue
 * @ingroup kFireSync-Server-Network
 * @brief   Run-time statistics for the data input service. 
 */
typedef struct kSvDataInStats
{
    k64u bytesRead;         ///< Total bytes received. 
    k64u throughput;        ///< Input rate (bytes/sec). 
} kSvDataInStats; 

/**
 * @internal
 * @class   kSvDataIn
 * @extends kObject
 * @ingroup kFireSync-Server-Network
 * @brief   Represents the data input service.
 */
//typedef kObject kSvDataIn;      --forward-declared in kFsDef.x.h
 
/** 
 * Constructs a kSvDataIn object.
 *
 * @public              @memberof kSvDataIn
 * @param   service     Destination for the constructed object handle. 
 * @param   node        Parent/owner.  
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kSvDataIn_Construct(kSvDataIn* service, kSvNode node, kAlloc allocator);

kFsFx(kStatus) kSvDataIn_BeginSession(kSvDataIn service);
kFsFx(kStatus) kSvDataIn_EndSession(kSvDataIn service, kBool synchronizeData);

kFsFx(kStatus) kSvDataIn_ClearStats(kSvDataIn service); 
kFsFx(kStatus) kSvDataIn_Stats(kSvDataIn service, kSvDataInStats* stats); 

#include <kFireSync/Server/Network/kSvDataIn.x.h>

#endif
