/** 
 * @file    kSvControlChannel.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_CONTROL_CHANNEL_X_H
#define K_FIRESYC_SERVER_CONTROL_CHANNEL_X_H

typedef struct kSvControlChannelClass
{
    kObjectClass base; 
    kSvNode node;                   //Node to be controlled. 
    
    kTcpClient client;              //Client connection. 
    kSerializer serializer;         //Message serializer. 

    kThread thread;                 //Thread to service client.

    k32u commandId;                 //Id of current command. 
    kBool replyStarted;             //Has client started formatting a reply?
    kBool replyAutoSize;            //Is the reply size calculated automatically?

    kBool shouldReset;              //Should the sensor reset when the channel disconnects?
    kBool restartApp;               //Should the sensor restart its software without fully rebooting?

    kVersion remoteProtocolVersion; //FireSync protocol version used by remote client.
    kVersion remotePlatformVersion; //FireSync platform version implemented by remote client.

    kAtomic32s hasExited;           //Is the channel still accepting commands?

} kSvControlChannelClass; 

kDeclareClassEx(kFs, kSvControlChannel, kObject)
        
kFsFx(kStatus) kSvControlChannel_Init(kSvControlChannel channel, kType type, kSvNode node, kTcpClient client, kAlloc alloc);
kFsFx(kStatus) kSvControlChannel_VRelease(kSvControlChannel channel);

kFsFx(kStatus) kSvControlChannel_ThreadEntry(kSvControlChannel channel); 

kFsFx(kStatus) kSvControlChannel_ProcessCommand(kSvControlChannel channel); 

kFsFx(kStatus) kSvControlChannel_BeginReadCommand(kSvControlChannel channel, k32u* id); 
kFsFx(kStatus) kSvControlChannel_EndReadCommand(kSvControlChannel channel); 

kFsFx(kStatus) kSvControlChannel_BeginWriteReply(kSvControlChannel channel, kSize contentSize, kStatus result); 
kFsFx(kStatus) kSvControlChannel_EndWriteReply(kSvControlChannel channel); 

kFsFx(kStatus) kSvControlChannel_ReadText(kSvControlChannel channel, kChar* text, kSize capacity); 
kFsFx(kStatus) kSvControlChannel_WriteGenericReply(kSvControlChannel channel, kStatus result); 

kFsFx(kStatus) kSvControlChannel_OnCommandError(kSvControlChannel channel, kStatus* status); 
kFsFx(kStatus) kSvControlChannel_FileProgressHandler(kSvControlChannel channel, kPointer sender, kPointer args); 

kFsFx(kStatus) kSvControlChannel_OnInformVersion(kSvControlChannel channel);

kFsFx(kStatus) kSvControlChannel_OnClearFirmware(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnWriteFirmware(kSvControlChannel channel, kCallbackFx progress); 
kFsFx(kStatus) kSvControlChannel_OnReloadFirmware(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnReset(kSvControlChannel channel); 

kFsFx(kStatus) kSvControlChannel_OnWriteFile(kSvControlChannel channel, kCallbackFx progress); 
kFsFx(kStatus) kSvControlChannel_OnCopyFile(kSvControlChannel channel, kCallbackFx progress); 
kFsFx(kStatus) kSvControlChannel_OnReadFile(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnDeleteFile(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnGetFileInfo(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnCreateDirectory(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnDeleteDirectory(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnListDirectoryEntries(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnListDirectoryEntriesEx(kSvControlChannel channel); 

kFsFx(kStatus) kSvControlChannel_OnSetDeviceConfig(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnGetDeviceConfig(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnCommitDeviceConfig(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnSetModeConfig(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnGetModeConfig(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnSaveModeConfig(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnLoadModeConfig(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnCommitModeConfig(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnValidateBlockConfig(kSvControlChannel channel); 

kFsFx(kStatus) kSvControlChannel_OnSetDateTime(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnIncrementInputCounter(kSvControlChannel channel);

kFsFx(kStatus) kSvControlChannel_OnCameraOverride(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnLightOverride(kSvControlChannel channel);

kFsFx(kStatus) kSvControlChannel_OnListProcedures(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnInvokeProcedure(kSvControlChannel channel); 

kFsFx(kStatus) kSvControlChannel_OnValidateActionConfig(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnInvokeAction(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnInvokeNamedAction(kSvControlChannel channel); 

kFsFx(kStatus) kSvControlChannel_OnSetVariable(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnGetVariable(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnGetVariableInfo(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnDeleteVariable(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnListVariables(kSvControlChannel channel); 

kFsFx(kStatus) kSvControlChannel_OnReadMemory(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnWriteMemory(kSvControlChannel channel);

kFsFx(kStatus) kSvControlChannel_OnReadRegisters(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnReadRegisterOverrides(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnWriteRegisterOverrides(kSvControlChannel channel);

kFsFx(kStatus) kSvControlChannel_OnI2cRead(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnI2cWrite(kSvControlChannel channel);

kFsFx(kStatus) kSvControlChannel_OnBeginSpi(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnEndSpi(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnSpiRead(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnSpiWrite(kSvControlChannel channel);

kFsFx(kStatus) kSvControlChannel_OnReadLogHistory(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnReadCrashLog(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnClearCrashLog(kSvControlChannel channel);

kFsFx(kStatus) kSvControlChannel_OnStart(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnStop(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnPause(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnResume(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnEngage(kSvControlChannel channel); 

kFsFx(kStatus) kSvControlChannel_OnStartReplay(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnReplay(kSvControlChannel channel); 

kFsFx(kStatus) kSvControlChannel_OnScheduleEvent(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnTriggerEvent(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnTriggerCamera(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnTriggerLight(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnSetLightState(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnSetDigitalOutState(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnTriggerDigitalOut(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnEnqueueAnalogOut(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnEnqueueAnalogOutCurrent(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnWriteAnalogOutCalibration(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnWriteSerialOut(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnWriteRamImage(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnWritePrnu(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnWriteFpn(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnWriteRangeLut(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnWritePhaseDecoderLut(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnSetCameraLvdsPower(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnGetCameraLvdsPower(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnWriteAccelerationTestData(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnReadAccelerationTestResult(kSvControlChannel channel);

kFsFx(kStatus) kSvControlChannel_OnLoadPatterns(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnLoadProjectorRowGains(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnLoadProjectorColGains(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnResetEncoder(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnEnableLed(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnSetLedMode(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnSetGpioState(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnGetGpioState(kSvControlChannel channel);

kFsFx(kStatus) kSvControlChannel_OnGetInfo(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnGetState(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnGetHealth(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnReadHealthLog(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnClearHealthLog(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnGetNodeStats(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnGetEventStats(kSvControlChannel channel); 
kFsFx(kStatus) kSvControlChannel_OnGetCameraStats(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnGetLightStats(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnGetProjectorStats(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnGetAnalogOutStats(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnGetDigitalOutStats(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnGetSerialOutStats(kSvControlChannel channel);

kFsFx(kStatus) kSvControlChannel_OnResetIoTest(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnGetIoTestStats(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnReadIoTestSerialData(kSvControlChannel channel);

kFsFx(kStatus) kSvControlChannel_OnTestJigCommand(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnGetTestJigStats(kSvControlChannel channel);

kFsFx(kStatus) kSvControlChannel_OnLockOutLight(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnSetLightDriverControl(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnGetLightDriverControl(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnSetLightDriverPower(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnGetLightDriverPower(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnSetLightDriverCurrentLimit(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnGetLightDriverCurrentLimit(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnGetLightDriverRemainingSlotCount(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnSetLightDriverInfo(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnGetLightDriverInfo(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnSetLightDriverCalibration(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnGetLightDriverCalibration(kSvControlChannel channel);
kFsFx(kStatus) kSvControlChannel_OnReadLightDriverTemperature(kSvControlChannel channel);

#endif
