/** 
 * @file    kSvSerialOut.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_SERIAL_OUT_X_H
#define K_FIRESYC_SERVER_SERIAL_OUT_X_H

typedef struct kSvSerialOutClass
{
    kObjectClass base; 
    
    kSvNode node;               //Server node (parent). 
    kHxSerialOut hwSerial;     //Hardware serial (kHxSerialOut).

} kSvSerialOutClass; 

kDeclareClassEx(kFs, kSvSerialOut, kObject)
        
kFsFx(kStatus) kSvSerialOut_Init(kSvSerialOut serial, kType type, kSvNode node, kHxSerialOut hwSerial, kAlloc alloc);
kFsFx(kStatus) kSvSerialOut_VRelease(kSvSerialOut serial);

kFsFx(kStatus) kSvSerialOut_Format(kSvSerialOut serial, kXml xml, kXmlItem item);

kFsFx(kStatus) kSvSerialOut_Parse(kSvSerialOut serial, kXml xml, kXmlItem item);

kFsFx(kStatus) kSvSerialOut_Write(kSvSerialOut serial, const void* buffer, kSize size);

kFsFx(kStatus) kSvSerialOut_Stats(kSvSerialOut serial, kSerialOutStats* stats);

#endif
