/** 
 * @file    kSvProjector.h
 * @brief   Declares the kSvProjector class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_PROJECTOR_H
#define K_FIRESYC_SERVER_PROJECTOR_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class       kSvProjector
 * @extends     kObject
 * @ingroup     kFireSync-Server-Devices
 * @brief       Lightweight server wrapper for kHxProjector. 
 */
//typedef kObject kSvProjector;          --forward-declared in kFsDef.x.h

/** 
 * Constructs a kSvProjector object.
 *
 * @public              @memberof kSvProjector
 * @param   projector      Destination for the constructed object handle. 
 * @param   node        Server node (parent). 
 * @param   hwProjector    Projector hardware driver handle. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kSvProjector_Construct(kSvProjector* projector, kSvNode node, kHxProjector hwProjector, kAlloc allocator);

kFsFx(kStatus) kSvProjector_Format(kSvProjector projector, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvProjector_Parse(kSvProjector projector, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvProjector_FormatDevice(kSvProjector projector, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvProjector_ParseDevice(kSvProjector projector, kXml xml, kXmlItem item);

kFsFx(kStatus) kSvProjector_LoadPatterns(kSvProjector projector, kArray2 patterns);
kFsFx(kStatus) kSvProjector_LoadRowGains(kSvProjector projector, kArray1 gains);
kFsFx(kStatus) kSvProjector_LoadColGains(kSvProjector projector, kArray1 gains);

kFsFx(kStatus) kSvProjector_Stats(kSvProjector projector, kProjectorStats* stats);

#include <kFireSync/Server/Devices/kSvProjector.x.h>

#endif

