/** 
 * @file    kSvAnalogOut.h
 * @brief   Declares the kSvAnalogOut class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_ANALOG_OUT_H
#define K_FIRESYC_SERVER_ANALOG_OUT_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class       kSvAnalogOut
 * @extends     kObject
 * @ingroup     kFireSync-Server-Devices
 * @brief       Lightweight server wrapper for kHxAnalogOut. 
 */
//typedef kObject kSvAnalogOut;          --forward-declared in kFsDef.x.h

/** 
 * Constructs a kSvAnalogOut object.
 *
 * @public              @memberof kSvAnalogOut
 * @param   analog      Destination for the constructed object handle. 
 * @param   node        Server node (parent). 
 * @param   hwAnalog    Analog hardware driver handle. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kSvAnalogOut_Construct(kSvAnalogOut* analog, kSvNode node, kHxAnalogOut hwAnalog, kAlloc allocator);

kFsFx(kStatus) kSvAnalogOut_Format(kSvAnalogOut analog, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvAnalogOut_Parse(kSvAnalogOut analog, kXml xml, kXmlItem item);

kFsFx(kStatus) kSvAnalogOut_EnqueueValue(kSvAnalogOut analog, k32u value);

kFsFx(kStatus) kSvAnalogOut_EnqueueCurrent(kSvAnalogOut analog, k64f value);

kFsFx(kStatus) kSvAnalogOut_SetCalibration(kSvAnalogOut analog, kArray2 calibration);

kFsFx(kStatus) kSvAnalogOut_Stats(kSvAnalogOut analog, kAnalogOutStats* stats);

#include <kFireSync/Server/Devices/kSvAnalogOut.x.h>

#endif
