/** 
 * @file    kPxSerialPipe.h
 * @brief   Declares the kPxSerialPipe type. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PX_SERIAL_PIPE_H
#define K_FIRESYNC_PX_SERIAL_PIPE_H

#include <kFireSync/kNodeDef.h>

/**
 * @class   kPxSerialPipe
 * @extends kPxPipe
 * @ingroup kFireSync-Pipe
 * @brief   Pipe execution engine that completely processes an input message before processing the next input message.
 */
//typedef kObject kPxSerialPipe;        --forward-declared in kFsDef.x.h

/** 
 * Constructs a kPxSerialPipe instance. 
 * 
 * @public                  @memberof kPxSerialPipe
 * @param   pipe            Receives constructed pipe object. 
 * @param   nodeId          Unique identifier for pipe owner (typically a node id). 
 * @param   pipeEnviron     Environment provider object. 
 * @param   allocator       Memory allocator (or kNULL for default). 
 * @return                  Operation status. 
 */
kFsFx(kStatus) kPxSerialPipe_Construct(kPxSerialPipe* pipe, k32u nodeId, kPxEnviron pipeEnviron, kAlloc allocator);

#include <kFireSync/Pipe/kPxSerialPipe.x.h>

#endif
