/** 
 * @file    kPxReplayPipe.h
 * @brief   Declares the kPxReplayPipe type. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PX_REPLAY_PIPE_H
#define K_FIRESYNC_PX_REPLAY_PIPE_H

#include <kFireSync/kNodeDef.h>

/**
 * @class   kPxReplayPipe
 * @extends kPxPipe
 * @ingroup kFireSync-Pipe
 * @brief   Pipe execution engine used to synchronously reprocess messages. 
 */
//typedef kObject kPxReplayPipe;        --forward-declared in kFsDef.x.h

/** 
 * Constructs a kPxReplayPipe instance. 
 * 
 * @public                  @memberof kPxReplayPipe
 * @param   pipe            Receives constructed pipe object. 
 * @param   nodeId          Unique identifier for pipe owner (typically a node id). 
 * @param   pipeEnviron     Environment provider object. 
 * @param   allocator       Memory allocator (or kNULL for default). 
 * @return                  Operation status. 
 */
kFsFx(kStatus) kPxReplayPipe_Construct(kPxReplayPipe* pipe, k32u nodeId, kPxEnviron pipeEnviron, kAlloc allocator);

/** 
 * Gets output messages produced during replay. 
 * 
 * @public                  @memberof kPxReplayPipe
 * @param   pipe            Pipe object.
 * @param   output          Receives pipe output messages (ownership is transferred). 
 * @return                  Operation status. 
 */
kFsFx(kStatus) kPxReplayPipe_Output(kPxReplayPipe pipe, kArrayList output);

#include <kFireSync/Pipe/kPxReplayPipe.x.h>

#endif
